/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.data;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Either<L, R> {
    @Nullable
    private final L left;
    @Nullable
    private final R right;

    public Either(@Nullable L left, @Nullable R right) {
        if (left == null == (right == null)) {
            throw new IllegalArgumentException("Only one value must be present");
        }
        this.left = left;
        this.right = right;
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Either<Object, R>(null, right);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    @NotNull
    public Optional<L> getLeft() {
        return Optional.ofNullable(this.left);
    }

    @NotNull
    public Optional<R> getRight() {
        return Optional.ofNullable(this.right);
    }

    public Object get() {
        return this.left != null ? this.left : this.right;
    }

    public <T> T get(Class<T> type) {
        return type.cast(this.get());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[%s=%s]".formatted(this.isLeft() ? "left" : "right", this.get());
    }
}

