/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.fulib.fx.FulibFxApp;
import org.fulib.fx.util.FrameworkUtil;
import org.jetbrains.annotations.NotNull;

public class Modals {
    private Modals() {
    }

    public static <Display extends Parent> void showModal(FulibFxApp app, Stage currentStage, Display component, BiConsumer<Stage, Display> initializer) {
        Modals.showModal(app, currentStage, component, initializer, Map.of(), true);
    }

    public static <Display extends Parent> void showModal(FulibFxApp app, Display component, BiConsumer<Stage, Display> initializer) {
        Modals.showModal(app, app.stage(), component, initializer, Map.of(), true);
    }

    public static <Display extends Parent> void showModal(FulibFxApp app, Stage currentStage, Display component, Map<String, Object> params) {
        Modals.showModal(app, currentStage, component, (stage, controller) -> {}, params, true);
    }

    public static <Display extends Parent> void showModal(FulibFxApp app, Display component, Map<String, Object> params) {
        Modals.showModal(app, app.stage(), component, (stage, controller) -> {}, params, true);
    }

    public static <Display extends Parent> void showModal(FulibFxApp app, Stage currentStage, Display component) {
        Modals.showModal(app, currentStage, component, (stage, controller) -> {}, Map.of(), true);
    }

    public static <Display extends Parent> void showModal(FulibFxApp app, Display component) {
        Modals.showModal(app, app.stage(), component, (stage, controller) -> {}, Map.of(), true);
    }

    public static <Display extends Parent> void showModal(FulibFxApp app, Display component, BiConsumer<Stage, Display> initializer, Map<String, Object> params, boolean destroyOnClose) {
        Modals.showModal(app, app.stage(), component, initializer, params, destroyOnClose);
    }

    public static <Display extends Node> void showModal(FulibFxApp app, Stage currentStage, Display component, BiConsumer<Stage, Display> initializer, Map<String, Object> params, boolean destroyOnClose) {
        FulibFxApp.FX_SCHEDULER.scheduleDirect(() -> {
            ModalStage modalStage = new ModalStage(app, destroyOnClose, component);
            HashMap<String, Object> parameters = new HashMap<String, Object>(params);
            parameters.putIfAbsent("modalStage", (Object)modalStage);
            parameters.putIfAbsent("ownerStage", currentStage);
            app.frameworkComponent().controllerManager().init(component, parameters);
            Node rendered = app.frameworkComponent().controllerManager().render(component, parameters);
            if (!(rendered instanceof Parent)) {
                throw new IllegalArgumentException(FrameworkUtil.error(1011).formatted(component.getClass().getName()));
            }
            Parent parent = (Parent)rendered;
            app.getTitle(component).ifPresent(title -> modalStage.setTitle(app.formatTitle((String)title)));
            Scene scene = new Scene(parent);
            scene.setFill(Paint.valueOf((String)"transparent"));
            modalStage.setScene(scene);
            modalStage.initStyle(StageStyle.TRANSPARENT);
            modalStage.initOwner((Window)currentStage);
            modalStage.initModality(Modality.WINDOW_MODAL);
            modalStage.show();
            modalStage.requestFocus();
            initializer.accept(modalStage, component);
        });
    }

    public static class ModalStage
    extends Stage {
        private final FulibFxApp app;
        private final Object component;
        private final boolean destroyOnClose;

        public ModalStage(FulibFxApp app, boolean destroyOnClose, @NotNull Object component) {
            this.destroyOnClose = destroyOnClose;
            this.app = app;
            this.component = component;
        }

        public void hide() {
            if (this.destroyOnClose) {
                this.app.frameworkComponent().controllerManager().destroy(this.component);
            }
            super.hide();
        }
    }
}

