/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.inject.Inject;
import org.fulib.fx.FulibFxApp;
import org.fulib.fx.data.disposable.RefreshableCompositeDisposable;
import org.fulib.fx.data.disposable.RefreshableDisposableContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Subscriber
implements RefreshableDisposableContainer {
    @Nullable
    private RefreshableDisposableContainer disposable;

    @Inject
    public Subscriber() {
    }

    public void subscribe(@NotNull Runnable action) {
        this.disposable().add(Disposable.fromRunnable((Runnable)action));
    }

    public void subscribe(@NotNull Disposable disposable) {
        this.disposable().add(disposable);
    }

    public void subscribe(@NotNull Completable completable) {
        this.disposable().add(completable.observeOn(FulibFxApp.FX_SCHEDULER).subscribe());
    }

    public void subscribe(@NotNull Completable completable, @NotNull Action onComplete) {
        this.disposable().add(completable.observeOn(FulibFxApp.FX_SCHEDULER).subscribe(onComplete));
    }

    public void subscribe(@NotNull Completable completable, @NotNull @NotNull Consumer<? super @NotNull Throwable> onError) {
        this.disposable().add(completable.doOnError(onError).observeOn(FulibFxApp.FX_SCHEDULER).subscribe());
    }

    public <T> void subscribe(@NotNull @NotNull Observable<@NotNull T> observable, @NotNull Scheduler subscribeOn, @NotNull @NotNull Consumer<@NotNull T> onNext, @NotNull @NotNull Consumer<? super @NotNull Throwable> onError) {
        this.disposable().add(observable.subscribeOn(subscribeOn).observeOn(FulibFxApp.FX_SCHEDULER).subscribe(onNext, onError));
    }

    public <T> void subscribe(@NotNull @NotNull Observable<@NotNull T> observable) {
        this.subscribe(observable.ignoreElements());
    }

    public <T> void subscribe(@NotNull @NotNull Observable<@NotNull T> observable, @NotNull @NotNull Consumer<@NotNull T> onNext) {
        this.disposable().add(observable.observeOn(FulibFxApp.FX_SCHEDULER).subscribe(onNext));
    }

    public <T> void subscribe(@NotNull @NotNull Observable<@NotNull T> observable, @NotNull @NotNull Consumer<@NotNull T> onNext, @NotNull @NotNull Consumer<? super @NotNull Throwable> onError) {
        this.disposable().add(observable.observeOn(FulibFxApp.FX_SCHEDULER).subscribe(onNext, onError));
    }

    public <T> void listen(@NotNull @NotNull ObservableValue<@NotNull T> property, @NotNull @NotNull ChangeListener<? super @NotNull T> listener) {
        property.addListener(listener);
        this.subscribe(() -> property.removeListener(listener));
    }

    public void listen(@NotNull PropertyChangeSupport support, @NotNull String property, @NotNull PropertyChangeListener changeListener) {
        support.addPropertyChangeListener(property, changeListener);
        this.subscribe(() -> support.removePropertyChangeListener(property, changeListener));
    }

    public void listen(@NotNull PropertyChangeSupport support, @NotNull PropertyChangeListener changeListener) {
        support.addPropertyChangeListener(changeListener);
        this.subscribe(() -> support.removePropertyChangeListener(changeListener));
    }

    public <T> void bind(@NotNull @NotNull Property<@NotNull T> property, @NotNull @NotNull ObservableValue<@NotNull T> other) {
        property.bind(other);
        this.subscribe(() -> property.unbind());
    }

    public <T> void bindBidirectional(@NotNull @NotNull Property<@NotNull T> property, @NotNull @NotNull Property<@NotNull T> other) {
        property.bindBidirectional(other);
        this.subscribe(() -> property.unbindBidirectional(other));
    }

    @NotNull
    private RefreshableDisposableContainer disposable() {
        if (this.disposable == null || this.disposable.isDisposed()) {
            this.disposable = new RefreshableCompositeDisposable();
        }
        return this.disposable;
    }

    public boolean isDisposed() {
        if (this.disposable == null) {
            return false;
        }
        return this.disposable.isDisposed();
    }

    public void dispose() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }

    @Override
    public boolean refresh() {
        return this.disposable().refresh();
    }

    @Override
    public boolean isFresh() {
        return this.disposable().isFresh();
    }

    @Deprecated
    public boolean add(Disposable d) {
        return this.disposable().add(d);
    }

    @Deprecated
    public boolean remove(Disposable d) {
        return this.disposable != null && this.disposable.remove(d);
    }

    @Deprecated
    public boolean delete(Disposable d) {
        return this.disposable != null && this.disposable.delete(d);
    }
}

