/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.duplicate;

import java.util.HashMap;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.fulib.fx.duplicate.Duplicator;
import org.fulib.fx.duplicate.duplicators.impl.ButtonDuplicator;
import org.fulib.fx.duplicate.duplicators.impl.HBoxDuplicator;
import org.fulib.fx.duplicate.duplicators.impl.ImageViewDuplicator;
import org.fulib.fx.duplicate.duplicators.impl.LabelDuplicator;
import org.fulib.fx.duplicate.duplicators.impl.PaneDuplicator;
import org.fulib.fx.duplicate.duplicators.impl.RegionDuplicator;
import org.fulib.fx.duplicate.duplicators.impl.TextDuplicator;
import org.fulib.fx.duplicate.duplicators.impl.VBoxDuplicator;
import org.fulib.fx.util.FrameworkUtil;

public class Duplicators {
    private static final HashMap<Class<?>, Duplicator<?>> DUPLICATORS = new HashMap();

    public static <T> void register(Class<T> clazz, Duplicator<T> duplicator) {
        DUPLICATORS.put(clazz, duplicator);
    }

    public static <T> T duplicate(T object) {
        if (object == null) {
            return null;
        }
        if (!DUPLICATORS.containsKey(object.getClass())) {
            throw new IllegalArgumentException(FrameworkUtil.error(9006).formatted(object.getClass()));
        }
        Duplicator<?> duplicator = DUPLICATORS.get(object.getClass());
        return (T)duplicator.duplicate(object);
    }

    static {
        Duplicators.register(Button.class, new ButtonDuplicator());
        Duplicators.register(HBox.class, new HBoxDuplicator());
        Duplicators.register(VBox.class, new VBoxDuplicator());
        Duplicators.register(Region.class, new RegionDuplicator());
        Duplicators.register(Pane.class, new PaneDuplicator());
        Duplicators.register(Label.class, new LabelDuplicator());
        Duplicators.register(Text.class, new TextDuplicator());
        Duplicators.register(ImageView.class, new ImageViewDuplicator());
    }
}

