/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import javafx.scene.Node;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.Controller;
import org.fulib.fx.annotation.event.OnDestroy;
import org.fulib.fx.annotation.event.OnInit;
import org.fulib.fx.annotation.event.OnKey;
import org.fulib.fx.annotation.event.OnRender;
import org.fulib.fx.controller.exception.InvalidRouteFieldException;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerUtil {
    public static final Set<Class<? extends Annotation>> EVENT_ANNOTATIONS = Set.of(OnInit.class, OnRender.class, OnDestroy.class, OnKey.class);

    private ControllerUtil() {
    }

    public static boolean isComponent(@Nullable Object instance) {
        return instance != null && ControllerUtil.isComponent(instance.getClass());
    }

    public static boolean isComponent(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isAnnotationPresent(Component.class) && !clazz.isAnnotationPresent(Controller.class) && Node.class.isAssignableFrom(clazz);
    }

    public static boolean isControllerOrComponent(@Nullable Object instance) {
        return ControllerUtil.isController(instance) || ControllerUtil.isComponent(instance);
    }

    public static boolean isController(@Nullable Object instance) {
        return instance != null && ControllerUtil.isController(instance.getClass());
    }

    public static boolean isController(@Nullable Class<?> clazz) {
        return clazz != null && clazz.isAnnotationPresent(Controller.class) && !clazz.isAnnotationPresent(Component.class);
    }

    public static boolean canProvideSubComponent(Field field) {
        return ControllerUtil.isComponent(field.getType()) || ControllerUtil.isComponent(ReflectionUtil.getProvidedClass(field));
    }

    @NotNull
    public static String transform(@NotNull String className) {
        String[] classes = className.split("\\.");
        return classes[classes.length - 1].replace("Controller", "").replace("Component", "");
    }

    public static void requireControllerProvider(@NotNull Field field) {
        if (ControllerUtil.isControllerOrComponent(ReflectionUtil.getProvidedClass(field))) {
            throw new InvalidRouteFieldException(field);
        }
    }

    public static boolean isEventMethod(@NotNull Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (!EVENT_ANNOTATIONS.contains(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static void checkOverrides(Method method) {
        Method overridden = ReflectionUtil.getOverriding(method);
        if (overridden != null && ControllerUtil.isEventMethod(overridden)) {
            throw new RuntimeException(FrameworkUtil.error(1013).formatted(method.getName(), method.getDeclaringClass().getName(), overridden.getDeclaringClass().getName()));
        }
    }
}

