/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller.building;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.ModuleHelper;
import com.sun.javafx.reflect.ReflectUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.util.Builder;
import org.fulib.fx.controller.building.ControllerBuildFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ControllerProxyBuilder<T>
extends AbstractMap<String, Object>
implements Builder<T> {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private final ControllerBuildFactory buildFactory;
    private final Class<?> type;
    private final Map<String, Property> propertiesMap;
    private final Map<String, Object> userValues = new HashMap<String, Object>();
    private final Map<String, Object> containers = new HashMap<String, Object>();
    private Set<String> propertyNames;

    public ControllerProxyBuilder(ControllerBuildFactory factory, Class<?> tp) {
        this.type = tp;
        this.buildFactory = factory;
        this.propertiesMap = this.scanForSetters();
    }

    private static HashMap<String, LinkedList<Method>> getClassMethodCache(Class<?> type) {
        Method[] declaredMethods;
        HashMap<String, LinkedList<Method>> classMethodCache = new HashMap<String, LinkedList<Method>>();
        ReflectUtil.checkPackageAccess(type);
        for (Method method : declaredMethods = type.getMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            String name = method.getName();
            LinkedList namedMethods = classMethodCache.computeIfAbsent(name, k -> new LinkedList());
            namedMethods.add(method);
        }
        return classMethodCache;
    }

    private static Object[] convertListToArray(Object userValue, Class<?> localType) {
        Class<?> arrayType = localType.getComponentType();
        List l = (List)BeanAdapter.coerce((Object)userValue, List.class);
        return l.toArray((Object[])Array.newInstance(arrayType, 0));
    }

    @Override
    public Object put(String key, Object value) {
        this.userValues.put(key, value);
        return null;
    }

    private Object getTemporaryContainer(String propName) {
        return this.containers.computeIfAbsent(propName, this::getReadOnlyProperty);
    }

    private Object getReadOnlyProperty(String propName) {
        return new ArrayListWrapper();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getTemporaryContainer(key.toString()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        return this.getTemporaryContainer(key.toString());
    }

    public T build() {
        this.putAll(this.containers);
        this.propertyNames = this.userValues.keySet();
        Object retObj = this.createObjectFromDefaultConstructor();
        if (retObj != null) {
            return (T)retObj;
        }
        throw new RuntimeException("Cannot create instance of " + this.type.getCanonicalName() + " with given set of properties: " + this.userValues.keySet());
    }

    private Object createObjectFromDefaultConstructor() throws RuntimeException {
        Object retObj = this.createInstance();
        for (String propName : this.propertyNames) {
            try {
                Property property = this.propertiesMap.get(propName);
                property.invoke(retObj, this.getUserValue(propName, property.getType()));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return retObj;
    }

    private Object getUserValue(String key, Class<?> type) {
        Object val = this.userValues.get(key);
        if (val == null) {
            return null;
        }
        if (type.isAssignableFrom(val.getClass())) {
            return val;
        }
        if (type.isArray()) {
            try {
                return ControllerProxyBuilder.convertListToArray(val, type);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (ArrayListWrapper.class.equals(val.getClass())) {
            List l = (List)val;
            return l.get(0);
        }
        return val;
    }

    private Object createInstance() {
        ReflectUtil.checkPackageAccess(this.type);
        return this.buildFactory.getProvidedInstance(this.type);
    }

    private Map<String, Property> scanForSetters() {
        HashMap<String, Property> strsMap = new HashMap<String, Property>();
        HashMap<String, LinkedList<Method>> methods = ControllerProxyBuilder.getClassMethodCache(this.type);
        for (String methodName : methods.keySet()) {
            Class<?>[] argType;
            Class<?> retType;
            List methodsList;
            Object propName;
            if (methodName.startsWith(SETTER_PREFIX) && methodName.length() > SETTER_PREFIX.length()) {
                propName = methodName.substring(SETTER_PREFIX.length());
                propName = Character.toLowerCase(((String)propName).charAt(0)) + ((String)propName).substring(1);
                methodsList = (List)methods.get(methodName);
                for (Method m : methodsList) {
                    retType = m.getReturnType();
                    argType = m.getParameterTypes();
                    if (!retType.equals(Void.TYPE) || argType.length != 1) continue;
                    strsMap.put((String)propName, new Setter(m, argType[0]));
                }
            }
            if (!methodName.startsWith(GETTER_PREFIX) || methodName.length() <= GETTER_PREFIX.length()) continue;
            propName = methodName.substring(GETTER_PREFIX.length());
            propName = Character.toLowerCase(((String)propName).charAt(0)) + ((String)propName).substring(1);
            methodsList = (List)methods.get(methodName);
            for (Method m : methodsList) {
                retType = m.getReturnType();
                argType = m.getParameterTypes();
                if (!Collection.class.isAssignableFrom(retType) || argType.length != 0) continue;
                strsMap.put((String)propName, new Getter(m, retType));
            }
        }
        return strsMap;
    }

    private static class ArrayListWrapper<T>
    extends ArrayList<T> {
        private ArrayListWrapper() {
        }
    }

    private static abstract class Property {
        protected final Method method;
        protected final Class<?> type;

        public Property(Method m, Class<?> t) {
            this.method = m;
            this.type = t;
        }

        public Class<?> getType() {
            return this.type;
        }

        public abstract void invoke(Object var1, Object var2) throws Exception;
    }

    private static class Setter
    extends Property {
        public Setter(Method m, Class<?> t) {
            super(m, t);
        }

        @Override
        public void invoke(Object obj, Object argStr) throws Exception {
            Object[] arg = new Object[]{BeanAdapter.coerce((Object)argStr, (Class)this.type)};
            ModuleHelper.invoke((Method)this.method, (Object)obj, (Object[])arg);
        }
    }

    private static class Getter
    extends Property {
        public Getter(Method m, Class<?> t) {
            super(m, t);
        }

        @Override
        public void invoke(Object obj, Object argStr) throws Exception {
            Collection to = (Collection)ModuleHelper.invoke((Method)this.method, (Object)obj, (Object[])new Object[0]);
            if (argStr instanceof Collection) {
                Collection from = (Collection)argStr;
                to.addAll(from);
            } else {
                to.add(argStr);
            }
        }
    }
}

