/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.data.disposable;

import io.reactivex.rxjava3.disposables.Disposable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.fulib.fx.data.disposable.RefreshableDisposable;

public class ItemListDisposable<T>
implements RefreshableDisposable {
    private boolean disposed = false;
    private List<Disposable> disposables;
    private Consumer<T> onDispose;

    private ItemListDisposable() {
    }

    @SafeVarargs
    public static <T> ItemListDisposable<T> of(Consumer<T> onDispose, T ... toDispose) {
        return ItemListDisposable.of(onDispose, Arrays.asList(toDispose));
    }

    public static <T> ItemListDisposable<T> of(Consumer<T> onDispose, List<T> toDispose) {
        ItemListDisposable<T> listDisposable = new ItemListDisposable<T>();
        listDisposable.disposables = new ArrayList<Disposable>();
        listDisposable.onDispose = onDispose;
        for (Object item : toDispose) {
            listDisposable.disposables.add(0, Disposable.fromRunnable(() -> onDispose.accept(item)));
        }
        return listDisposable;
    }

    public void dispose() {
        for (Disposable disposable : this.disposables) {
            disposable.dispose();
        }
        this.disposables = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean refresh() {
        if (this.isDisposed()) {
            this.disposables = new ArrayList<Disposable>();
            this.disposed = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFresh() {
        return !this.isDisposed() && this.disposables.isEmpty();
    }

    public void add(T item) {
        this.disposables.add(Disposable.fromRunnable(() -> this.onDispose.accept(item)));
    }
}

