/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller;

import dagger.Lazy;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.util.Pair;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.fulib.fx.annotation.Route;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.Controller;
import org.fulib.fx.controller.ControllerManager;
import org.fulib.fx.controller.exception.ControllerDuplicatedRouteException;
import org.fulib.fx.controller.exception.ControllerInvalidRouteException;
import org.fulib.fx.data.Either;
import org.fulib.fx.data.EvictingQueue;
import org.fulib.fx.data.SizeableTraversableQueue;
import org.fulib.fx.data.TraversableNodeTree;
import org.fulib.fx.data.TraversableTree;
import org.fulib.fx.util.ControllerUtil;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.ReflectionUtil;
import org.fulib.fx.util.reflection.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class Router {
    private final TraversableTree<Field> routes = new TraversableNodeTree<Field>();
    private final SizeableTraversableQueue<Pair<Either<TraversableNodeTree.Node<Field>, Object>, Map<String, Object>>> history = new EvictingQueue<Pair<Either<TraversableNodeTree.Node<Field>, Object>, Map<String, Object>>>(5);
    @Inject
    Lazy<ControllerManager> manager;
    private Object routerObject;

    @Inject
    public Router() {
    }

    public void registerRoutes(@NotNull Object routes) {
        if (this.routerObject != null) {
            throw new IllegalStateException(FrameworkUtil.error(3000).formatted(this.routerObject.getClass().getName()));
        }
        this.routerObject = routes;
        Reflection.getFieldsWithAnnotation(routes.getClass(), Route.class).forEach(this::registerRoute);
    }

    private void registerRoute(@NotNull Field field) {
        if (!field.isAnnotationPresent(Route.class)) {
            throw new RuntimeException(FrameworkUtil.error(3001).formatted(field.getName()));
        }
        ControllerUtil.requireControllerProvider(field);
        Route annotation = field.getAnnotation(Route.class);
        Object route = annotation.value().equals("$name") ? "/" + field.getName() : annotation.value();
        Object object = route = ((String)route).startsWith("/") ? route : "/" + (String)route;
        if (this.routes.containsPath((String)route)) {
            throw new ControllerDuplicatedRouteException((String)route, field.getType(), this.routes.get((String)route).getType());
        }
        this.routes.insert((String)route, field);
    }

    @NotNull
    public Pair<Object, Parent> renderRoute(@NotNull String route, @NotNull @NotNull Map<@NotNull String, @Nullable Object> parameters) {
        if (!this.routes.containsPath(route)) {
            Object message = FrameworkUtil.error(3005).formatted(route);
            if (this.routes.containsPath("/" + route)) {
                message = (String)message + " " + FrameworkUtil.note(3005).formatted("/" + route);
            }
            throw new ControllerInvalidRouteException((String)message);
        }
        Field provider = this.routes.traverse(route);
        TraversableNodeTree.Node node = ((TraversableNodeTree)this.routes).currentNode();
        this.addToHistory((Pair<Either<TraversableNodeTree.Node<Field>, Object>, Map<String, Object>>)new Pair(Either.left(node), parameters));
        Class<?> controllerClass = ReflectionUtil.getProvidedClass(Objects.requireNonNull(provider));
        if (controllerClass == null) {
            throw new RuntimeException(FrameworkUtil.error(3004).formatted(provider.getName(), this.routerObject.getClass().getName()));
        }
        if (!controllerClass.isAnnotationPresent(Controller.class) && !controllerClass.isAnnotationPresent(Component.class)) {
            throw new RuntimeException(FrameworkUtil.error(1001).formatted(controllerClass.getName()));
        }
        Object controllerInstance = ReflectionUtil.getInstanceOfProviderField(provider, this.routerObject);
        Node renderedNode = ((ControllerManager)this.manager.get()).initAndRender(controllerInstance, parameters);
        if (renderedNode instanceof Parent) {
            Parent parent = (Parent)renderedNode;
            return new Pair(controllerInstance, (Object)parent);
        }
        throw new RuntimeException(FrameworkUtil.error(1011).formatted(controllerClass.getName()));
    }

    public Object getController(String route) {
        Field provider = this.routes.get((String)(route.startsWith("/") ? route : "/" + route));
        return ReflectionUtil.getInstanceOfProviderField(provider, this.routerObject);
    }

    public void addToHistory(Pair<Either<TraversableNodeTree.Node<Field>, Object>, Map<String, Object>> pair) {
        this.history.insert(pair);
    }

    public Pair<Object, Node> back() {
        try {
            Pair pair = (Pair)this.history.back();
            return this.navigate((Pair<Either<TraversableNodeTree.Node<Field>, Object>, Map<String, Object>>)pair);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Pair<Object, Node> forward() {
        try {
            Pair pair = (Pair)this.history.forward();
            return this.navigate((Pair<Either<TraversableNodeTree.Node<Field>, Object>, Map<String, Object>>)pair);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Pair<Object, Node> navigate(Pair<Either<TraversableNodeTree.Node<Field>, Object>, Map<String, Object>> pair) {
        Either either = (Either)pair.getKey();
        either.getLeft().ifPresent(node -> ((TraversableNodeTree)this.routes).setCurrentNode(node));
        Object controller = either.isLeft() ? ReflectionUtil.getInstanceOfProviderField((Field)((TraversableNodeTree.Node)either.getLeft().orElseThrow()).value(), this.routerObject) : either.getRight().orElseThrow();
        ((ControllerManager)this.manager.get()).cleanup();
        return new Pair(controller, (Object)((ControllerManager)this.manager.get()).initAndRender(controller, (Map)pair.getValue()));
    }

    public Pair<Object, Map<String, Object>> current() {
        Either either = (Either)((Pair)this.history.current()).getKey();
        return new Pair(either.isLeft() ? either.getLeft().map(node -> {
            try {
                Objects.requireNonNull((Field)node.value()).setAccessible(true);
                return ((Provider)Objects.requireNonNull((Field)node.value()).get(this.routerObject)).get();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).orElseThrow() : either.getRight().orElseThrow(), (Object)((Map)((Pair)this.history.current()).getValue()));
    }

    public void setHistorySize(int size) {
        this.history.setSize(size);
    }
}

