/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.fulib.fx.FulibFxApp;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.Controller;
import org.fulib.fx.annotation.controller.Resource;
import org.fulib.fx.annotation.controller.SubComponent;
import org.fulib.fx.annotation.controller.Title;
import org.fulib.fx.annotation.event.OnDestroy;
import org.fulib.fx.annotation.event.OnInit;
import org.fulib.fx.annotation.event.OnKey;
import org.fulib.fx.annotation.event.OnRender;
import org.fulib.fx.annotation.param.Param;
import org.fulib.fx.annotation.param.Params;
import org.fulib.fx.annotation.param.ParamsMap;
import org.fulib.fx.controller.ControllerManager;
import org.fulib.fx.controller.internal.FxSidecar;
import org.fulib.fx.util.ControllerUtil;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.MapUtil;
import org.fulib.fx.util.ReflectionUtil;
import org.fulib.fx.util.reflection.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ReflectionSidecar<T>
implements FxSidecar<T> {
    private final ControllerManager controllerManager;
    private final String title;
    private final Field resourceField;
    private final List<Field> subComponentFields;
    private final List<Field> paramFields;
    private final List<Field> paramsMapFields;
    private final List<Method> paramMethods;
    private final List<Method> paramsMethods;
    private final List<Method> paramsMapMethods;
    private final List<Method> initMethods;
    private final List<Method> renderMethods;
    private final List<Method> destroyMethods;

    public ReflectionSidecar(ControllerManager controllerManager, Class<T> componentClass) {
        this.controllerManager = controllerManager;
        this.title = this.loadTitle(componentClass);
        this.resourceField = this.loadResourceField(componentClass);
        this.subComponentFields = this.loadSubComponentFields(componentClass);
        this.initMethods = ReflectionUtil.getAllNonPrivateMethodsOrThrow(componentClass, OnInit.class).peek(ControllerUtil::checkOverrides).sorted(Comparator.comparingInt(m -> m.getAnnotation(OnInit.class).value())).toList();
        this.renderMethods = ReflectionUtil.getAllNonPrivateMethodsOrThrow(componentClass, OnRender.class).sorted(Comparator.comparingInt(m -> m.getAnnotation(OnRender.class).value())).peek(ControllerUtil::checkOverrides).toList();
        this.destroyMethods = ReflectionUtil.getAllNonPrivateMethodsOrThrow(componentClass, OnDestroy.class).peek(ControllerUtil::checkOverrides).sorted(Comparator.comparingInt(m -> m.getAnnotation(OnDestroy.class).value())).toList();
        this.paramFields = ReflectionUtil.getAllNonPrivateFieldsOrThrow(componentClass, Param.class).toList();
        this.paramsMapFields = ReflectionUtil.getAllNonPrivateFieldsOrThrow(componentClass, ParamsMap.class).peek(field -> {
            if (!MapUtil.isMapWithTypes(field, String.class, Object.class)) {
                throw new RuntimeException(FrameworkUtil.error(4002).formatted(field.getName(), componentClass.getName()));
            }
        }).toList();
        this.paramMethods = ReflectionUtil.getAllNonPrivateMethodsOrThrow(componentClass, Param.class).toList();
        this.paramsMethods = ReflectionUtil.getAllNonPrivateMethodsOrThrow(componentClass, Params.class).toList();
        this.paramsMapMethods = ReflectionUtil.getAllNonPrivateMethodsOrThrow(componentClass, ParamsMap.class).peek(method -> {
            if (method.getParameterCount() != 1 || !MapUtil.isMapWithTypes(method.getParameters()[0], String.class, Object.class)) {
                throw new RuntimeException(FrameworkUtil.error(4003).formatted(method.getName(), componentClass.getName()));
            }
        }).toList();
    }

    @Override
    public void init(T instance, Map<String, Object> params) {
        this.fillParametersIntoFields(instance, params);
        this.callParamMethods(instance, params);
        this.callParamsMethods(instance, params);
        this.callParamsMapMethods(instance, params);
        this.callMethodsWithAnnotation(instance, params, this.initMethods, OnInit.class);
        Reflection.callMethodsForFieldInstances(instance, this.subComponentFields, subcomponent -> this.controllerManager.init(subcomponent, params));
    }

    private void callMethodsWithAnnotation(@NotNull Object instance, @NotNull @NotNull Map<@NotNull String, @Nullable Object> parameters, List<Method> methods, @NotNull Class<? extends Annotation> annotation) {
        for (Method method : methods) {
            try {
                method.setAccessible(true);
                method.invoke(instance, this.getApplicableParameters(method, parameters));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(FrameworkUtil.error(1005).formatted(method.getName(), annotation.getName(), instance.getClass().getName()), e);
            }
        }
    }

    private void fillParametersIntoFields(@NotNull Object instance, @NotNull @NotNull Map<@NotNull String, @Nullable Object> parameters) {
        for (Field field : this.paramFields) {
            Param paramAnnotation = field.getAnnotation(Param.class);
            String param = paramAnnotation.value();
            if (!parameters.containsKey(param)) continue;
            Class<?> fieldType = field.getType();
            try {
                field.setAccessible(true);
                Object value = parameters.get(param);
                Object fieldValue = field.get(instance);
                if (WritableValue.class.isAssignableFrom(fieldType) && !(value instanceof WritableValue)) {
                    if (fieldValue == null) {
                        throw new RuntimeException(FrameworkUtil.error(4001).formatted(param, field.getName(), instance.getClass().getName()));
                    }
                    try {
                        ((WritableValue)field.get(instance)).setValue(value);
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException(FrameworkUtil.error(4007).formatted(param, field.getName(), instance.getClass().getName(), fieldType.getName(), value == null ? "null" : value.getClass().getName()));
                    }
                }
                if (value == null) {
                    if (fieldType.isPrimitive()) {
                        throw new RuntimeException(FrameworkUtil.error(4007).formatted(param, field.getName(), instance.getClass().getName(), fieldType.getName(), "null"));
                    }
                    field.set(instance, null);
                    continue;
                }
                if (Reflection.canBeAssigned(fieldType, value)) {
                    field.set(instance, value);
                    continue;
                }
                throw new RuntimeException(FrameworkUtil.error(4007).formatted(param, field.getName(), instance.getClass().getName(), fieldType.getName(), value.getClass().getName()));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(FrameworkUtil.error(4000).formatted(param, field.getName(), instance.getClass().getName()), e);
            }
        }
        for (Field field : this.paramsMapFields) {
            try {
                field.setAccessible(true);
                if (Modifier.isFinal(field.getModifiers())) {
                    Map map = (Map)field.get(instance);
                    map.clear();
                    map.putAll(parameters);
                    continue;
                }
                field.set(instance, parameters);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(FrameworkUtil.error(4010).formatted(field.getName(), instance.getClass().getName()), e);
            }
        }
    }

    private void callParamMethods(Object instance, Map<String, Object> parameters) {
        for (Method method : this.paramMethods) {
            try {
                method.setAccessible(true);
                Object value = parameters.get(method.getAnnotation(Param.class).value());
                if (value == null) {
                    method.invoke(instance, new Object[]{null});
                    continue;
                }
                if (Reflection.canBeAssigned(method.getParameterTypes()[0], value)) {
                    method.invoke(instance, value);
                    continue;
                }
                throw new RuntimeException(FrameworkUtil.error(4008).formatted(method.getAnnotation(Param.class).value(), method.getName(), instance.getClass().getName(), method.getParameterTypes()[0].getName(), value.getClass().getName()));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(FrameworkUtil.error(4005).formatted(method.getAnnotation(Param.class).value(), method.getName(), instance.getClass().getName()), e);
            }
        }
    }

    private void callParamsMethods(Object instance, Map<String, Object> parameters) {
        for (Method method : this.paramsMethods) {
            try {
                method.setAccessible(true);
                String[] paramNames = method.getAnnotation(Params.class).value();
                if (method.getParameters().length != paramNames.length) {
                    throw new RuntimeException(FrameworkUtil.error(4006).formatted(method.getName(), instance.getClass().getName()));
                }
                Object[] methodParams = new Object[paramNames.length];
                for (int i = 0; i < paramNames.length; ++i) {
                    Object value = parameters.get(paramNames[i]);
                    if (!Reflection.canBeAssigned(method.getParameterTypes()[i], value)) {
                        throw new RuntimeException(FrameworkUtil.error(4008).formatted(paramNames[i], method.getName(), instance.getClass().getName(), method.getParameterTypes()[i].getName(), value.getClass().getName()));
                    }
                    methodParams[i] = value;
                }
                method.invoke(instance, methodParams);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(FrameworkUtil.error(4011).formatted(method.getName(), instance.getClass().getName()), e);
            }
        }
    }

    private void callParamsMapMethods(Object instance, Map<String, Object> parameters) {
        for (Method method : this.paramsMapMethods) {
            try {
                method.setAccessible(true);
                method.invoke(instance, parameters);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(FrameworkUtil.error(4010).formatted(method.getName(), instance.getClass().getName()), e);
            }
        }
    }

    private @Nullable Object @NotNull [] getApplicableParameters(@NotNull Method method, @NotNull Map<String, Object> parameters) {
        return Arrays.stream(method.getParameters()).map(parameter -> {
            Param param = parameter.getAnnotation(Param.class);
            ParamsMap paramsMap = parameter.getAnnotation(ParamsMap.class);
            if (param != null && paramsMap != null) {
                throw new RuntimeException(FrameworkUtil.error(4009).formatted(parameter.getName(), method.getName(), method.getDeclaringClass().getName()));
            }
            if (param != null) {
                if (parameters.containsKey(param.value()) && !Reflection.canBeAssigned(parameter.getType(), parameters.get(param.value()))) {
                    throw new RuntimeException(FrameworkUtil.error(4008).formatted(param.value(), method.getName(), method.getDeclaringClass().getName(), parameter.getType().getName(), parameters.get(param.value()).getClass().getName()));
                }
                return parameters.get(param.value());
            }
            if (paramsMap != null) {
                if (!MapUtil.isMapWithTypes(parameter, String.class, Object.class)) {
                    throw new RuntimeException(FrameworkUtil.error(4004).formatted(parameter.getName(), method.getName(), method.getDeclaringClass().getName()));
                }
                return parameters;
            }
            return null;
        }).toArray();
    }

    private @Unmodifiable List<Field> loadSubComponentFields(Class<T> componentClass) {
        return ReflectionUtil.getAllNonPrivateFieldsOrThrow(componentClass, SubComponent.class).filter(field -> {
            if (ControllerUtil.isComponent(field.getType())) {
                return true;
            }
            if (!ControllerUtil.canProvideSubComponent(field)) {
                FulibFxApp.LOGGER.warning(FrameworkUtil.error(6005).formatted(field.getName(), componentClass.getName()));
            }
            return false;
        }).toList();
    }

    @Override
    public Node render(T instance, Map<String, Object> params) {
        Reflection.callMethodsForFieldInstances(instance, this.subComponentFields, subcomponent -> this.controllerManager.render(subcomponent, params));
        boolean component = ControllerUtil.isComponent(instance);
        Node node = this.renderNode(instance, component);
        this.callMethodsWithAnnotation(instance, params, this.renderMethods, OnRender.class);
        this.registerKeyEvents(instance);
        return node;
    }

    private Node renderNode(T instance, boolean component) {
        Node node;
        String view;
        String string = view = component ? instance.getClass().getAnnotation(Component.class).view() : instance.getClass().getAnnotation(Controller.class).view();
        if (component) {
            if (view.isEmpty()) {
                node = (Node)instance;
            } else {
                Node root = (Node)instance;
                if (root instanceof Parent) {
                    Parent parent = (Parent)root;
                    ReflectionUtil.getChildrenList(instance.getClass(), parent).clear();
                }
                node = this.controllerManager.loadFXML(view, instance, true);
            }
        } else if (view.startsWith("#")) {
            String methodName = view.substring(1);
            try {
                Method method = instance.getClass().getDeclaredMethod(methodName, new Class[0]);
                if (method.getParameterCount() != 0) {
                    throw new RuntimeException(FrameworkUtil.error(1008).formatted(methodName, instance.getClass().getName()));
                }
                if (!Parent.class.isAssignableFrom(method.getReturnType())) {
                    throw new RuntimeException(FrameworkUtil.error(1002).formatted(methodName, instance.getClass().getName()));
                }
                method.setAccessible(true);
                node = (Parent)method.invoke(instance, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(FrameworkUtil.error(1003).formatted(methodName, instance.getClass().getName()), e);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(FrameworkUtil.error(1004).formatted(methodName, instance.getClass().getName()), e);
            }
        } else {
            String fxmlPath = view.isEmpty() ? ControllerUtil.transform(instance.getClass().getSimpleName()) + ".fxml" : view;
            node = this.controllerManager.loadFXML(fxmlPath, instance, false);
        }
        return node;
    }

    private void registerKeyEvents(Object instance) {
        ReflectionUtil.getAllNonPrivateMethodsOrThrow(instance.getClass(), OnKey.class).forEach(method -> {
            OnKey[] annotations;
            ControllerUtil.checkOverrides(method);
            for (OnKey annotation : annotations = (OnKey[])method.getAnnotationsByType(OnKey.class)) {
                EventType<KeyEvent> type = annotation.type().asEventType();
                EventHandler<KeyEvent> handler = this.createKeyEventHandler((Method)method, instance, annotation);
                this.controllerManager.addKeyEventHandler(instance, annotation.target(), type, handler);
            }
        });
    }

    private EventHandler<KeyEvent> createKeyEventHandler(Method method, Object instance, OnKey annotation) {
        boolean hasEventParameter;
        boolean bl = hasEventParameter = method.getParameterCount() == 1 && method.getParameterTypes()[0].isAssignableFrom(KeyEvent.class);
        if (!hasEventParameter && method.getParameterCount() != 0) {
            throw new RuntimeException(FrameworkUtil.error(1010).formatted(method.getName(), instance.getClass().getName()));
        }
        method.setAccessible(true);
        return event -> {
            if (this.keyEventMatchesAnnotation((KeyEvent)event, annotation)) {
                try {
                    if (hasEventParameter) {
                        method.invoke(instance, event);
                    } else {
                        method.invoke(instance, new Object[0]);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(FrameworkUtil.error(1005).formatted(method.getName(), annotation.getClass().getSimpleName(), method.getClass()), e);
                }
            }
        };
    }

    private boolean keyEventMatchesAnnotation(KeyEvent event, OnKey onKey) {
        if (onKey.code() != KeyCode.UNDEFINED && event.getCode() != onKey.code()) {
            return false;
        }
        if (!onKey.character().isEmpty() && !event.getCharacter().equals(onKey.character())) {
            return false;
        }
        if (!onKey.text().isEmpty() && !event.getText().equals(onKey.text())) {
            return false;
        }
        if (onKey.strict()) {
            return onKey.shift() == event.isShiftDown() && onKey.control() == event.isControlDown() && onKey.alt() == event.isAltDown() && onKey.meta() == event.isMetaDown();
        }
        return !(onKey.shift() && !event.isShiftDown() || onKey.control() && !event.isControlDown() || onKey.alt() && !event.isAltDown() || onKey.meta() && !event.isMetaDown());
    }

    @Override
    public void destroy(T instance) {
        ArrayList<Field> subComponentFields = new ArrayList<Field>(this.subComponentFields);
        Collections.reverse(subComponentFields);
        Reflection.callMethodsForFieldInstances(instance, subComponentFields, this.controllerManager::destroy);
        this.callMethodsWithAnnotation(instance, Map.of(), this.destroyMethods, OnDestroy.class);
    }

    @Nullable
    private Field loadResourceField(Class<T> componentClass) {
        List<Field> fields = ReflectionUtil.getAllNonPrivateFieldsOrThrow(componentClass, Resource.class).toList();
        if (fields.isEmpty()) {
            return null;
        }
        if (fields.size() > 1) {
            throw new RuntimeException(FrameworkUtil.error(2003).formatted(componentClass.getName()));
        }
        Field field = fields.get(0);
        if (!field.getType().isAssignableFrom(ResourceBundle.class)) {
            throw new RuntimeException(FrameworkUtil.error(2004).formatted(field.getName(), componentClass.getName()));
        }
        field.setAccessible(true);
        return field;
    }

    @Override
    @Nullable
    public ResourceBundle getResources(T instance) {
        if (this.resourceField == null) {
            return this.controllerManager.getDefaultResourceBundle();
        }
        try {
            return (ResourceBundle)this.resourceField.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(FrameworkUtil.error(2005).formatted(this.resourceField.getName(), instance.getClass().getName()), e);
        }
    }

    private String loadTitle(Class<T> componentClass) {
        if (!componentClass.isAnnotationPresent(Title.class)) {
            return null;
        }
        String title = componentClass.getAnnotation(Title.class).value();
        if ("$name".equals(title)) {
            return ControllerUtil.transform(componentClass.getSimpleName());
        }
        return title;
    }

    @Override
    @Nullable
    public String getTitle(T instance) {
        if (this.title == null || !this.title.startsWith("%")) {
            return this.title;
        }
        ResourceBundle resourceBundle = this.getResources(instance);
        if (resourceBundle == null) {
            throw new RuntimeException(FrameworkUtil.error(2006).formatted(this.title, instance.getClass().getName()));
        }
        return resourceBundle.getString(this.title.substring(1));
    }
}

