/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.inject.Provider;
import org.fulib.fx.FulibFxApp;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.reflection.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    private static Field mouseHandlerField;
    private static Constructor<?> mouseHandlerCtor;

    private ReflectionUtil() {
    }

    @Nullable
    public static Class<?> getProvidedClass(@NotNull Field providerField) {
        Type type;
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        Type genericType;
        if (providerField.getType() == Provider.class && (genericType = providerField.getGenericType()) instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && (type = typeArguments[0]) instanceof Class) {
            Class genericClass = (Class)type;
            return genericClass;
        }
        return null;
    }

    public static ObservableList<Node> getChildrenList(Class<?> clazz, Parent parent) {
        try {
            Method getChildren = clazz.getDeclaredMethod("getChildren", new Class[0]);
            getChildren.setAccessible(true);
            Object childrenList = getChildren.invoke((Object)parent, new Object[0]);
            return (ObservableList)childrenList;
        }
        catch (Exception e) {
            if (clazz.getSuperclass() == Object.class) {
                throw new RuntimeException(FrameworkUtil.error(9003).formatted(parent.getClass().getName()), e);
            }
            return ReflectionUtil.getChildrenList(clazz.getSuperclass(), parent);
        }
    }

    public static Object getInstanceOfProviderField(Field provider, Object instance) {
        try {
            provider.setAccessible(true);
            Provider providerInstance = (Provider)provider.get(instance);
            if (providerInstance == null) {
                throw new RuntimeException(FrameworkUtil.error(9002).formatted(provider.getName(), provider.getDeclaringClass().getName()));
            }
            return providerInstance.get();
        }
        catch (NullPointerException e) {
            throw new RuntimeException(FrameworkUtil.error(9002).formatted(provider.getName(), provider.getDeclaringClass().getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(FrameworkUtil.error(9001).formatted(provider.getName(), instance.getClass().getName()), e);
        }
    }

    public static void resetMouseHandler(Stage stage) {
        try {
            Scene scene = stage.getScene();
            Object mouseHandler = mouseHandlerCtor.newInstance(scene);
            mouseHandlerField.set(scene, mouseHandler);
        }
        catch (ReflectiveOperationException e) {
            FulibFxApp.LOGGER.warning("Could not reset mouse handler. This may cause problems with mouse drag events after refreshing the scene.");
        }
    }

    public static Stream<Field> getAllNonPrivateFieldsOrThrow(@NotNull Class<?> clazz, @NotNull @NotNull Class<? extends @NotNull Annotation> annotation) {
        return Reflection.getAllFieldsWithAnnotation(clazz, annotation).peek(field -> {
            if (Modifier.isPrivate(field.getModifiers())) {
                throw new RuntimeException(FrameworkUtil.error(1012).formatted(Field.class.getSimpleName(), field.getName(), field.getDeclaringClass().getName()));
            }
        });
    }

    public static Stream<Method> getAllNonPrivateMethodsOrThrow(@NotNull Class<?> clazz, @NotNull @NotNull Class<? extends @NotNull Annotation> annotation) {
        return Reflection.getAllMethodsWithAnnotation(clazz, annotation).peek(method -> {
            if (Modifier.isPrivate(method.getModifiers())) {
                throw new RuntimeException(FrameworkUtil.error(1012).formatted(Method.class.getSimpleName(), method.getName(), method.getDeclaringClass().getName()));
            }
        });
    }

    @Nullable
    public static Method getOverriding(@NotNull Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        for (Class<?> superclass = declaringClass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            try {
                return superclass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    static {
        try {
            mouseHandlerField = Scene.class.getDeclaredField("mouseHandler");
            mouseHandlerCtor = Class.forName(Scene.class.getName() + "$MouseHandler").getDeclaredConstructor(Scene.class);
            mouseHandlerField.setAccessible(true);
            mouseHandlerCtor.setAccessible(true);
        }
        catch (ReflectiveOperationException | InaccessibleObjectException e) {
            FulibFxApp.LOGGER.severe("Could not initialize mouse handler reflection. This may cause problems with mouse drag events.");
        }
    }
}

