/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.fulib.fx.util.FrameworkUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Reflection {
    private Reflection() {
    }

    public static Stream<Field> getFieldsWithAnnotation(@NotNull Class<?> clazz, @NotNull @NotNull Class<? extends @NotNull Annotation> annotation) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getAnnotationsByType(annotation).length > 0);
    }

    public static Stream<Field> getAllFieldsWithAnnotation(@NotNull Class<?> clazz, @NotNull @NotNull Class<? extends @NotNull Annotation> annotation) {
        return Reflection.getAllFields(clazz).stream().filter(field -> field.getAnnotationsByType(annotation).length > 0);
    }

    public static void callMethodsForFieldInstances(@NotNull Object instance, @NotNull @NotNull Collection<@NotNull Field> fields, @NotNull @NotNull Consumer<@NotNull Object> method) {
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                Object component = field.get(instance);
                method.accept(component);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(FrameworkUtil.error(9000).formatted(field.getName(), instance.getClass().getName()), e);
            }
        }
    }

    public static Stream<Field> getFieldsOfType(@NotNull Class<?> clazz, @NotNull Class<?> type) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getType().equals(type));
    }

    public static Stream<Field> getAllFieldsOfType(@NotNull Class<?> clazz, @NotNull Class<?> type) {
        return Reflection.getAllFields(clazz).stream().filter(field -> field.getType().equals(type));
    }

    public static Stream<Method> getMethodsWithAnnotation(@NotNull Class<?> clazz, @NotNull @NotNull Class<? extends @NotNull Annotation> annotation) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getAnnotationsByType(annotation).length > 0);
    }

    public static Stream<Method> getAllMethodsWithAnnotation(@NotNull Class<?> clazz, @NotNull @NotNull Class<? extends @NotNull Annotation> annotation) {
        return Reflection.getAllMethods(clazz, false).stream().filter(method -> method.getAnnotationsByType(annotation).length > 0);
    }

    public static boolean canBeAssigned(@NotNull Class<?> type, @Nullable Object value) {
        if (value == null) {
            return !type.isPrimitive();
        }
        Class<?> valueType = value.getClass();
        return Reflection.getWrapperType(type).isAssignableFrom(valueType);
    }

    public static Class<?> getWrapperType(@NotNull Class<?> type) {
        return type.isPrimitive() ? Reflection.wrap(type) : type;
    }

    public static <T> Class<T> wrap(@NotNull Class<T> unwrapped) {
        return MethodType.methodType(unwrapped).wrap().returnType();
    }

    public static <T> Class<T> unwrap(@NotNull Class<T> wrapped) {
        return MethodType.methodType(wrapped).unwrap().returnType();
    }

    public static List<Field> getAllFields(@NotNull Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        while (clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields;
    }

    public static List<Method> getAllMethods(@NotNull Class<?> clazz, boolean includeObjectMethods) {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(clazz.getDeclaredMethods()));
        while (clazz.getSuperclass() != null && (includeObjectMethods || clazz.getSuperclass() != Object.class)) {
            clazz = clazz.getSuperclass();
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
        return methods;
    }
}

