/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.constructs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import org.fulib.fx.FulibFxApp;
import org.fulib.fx.util.ControllerUtil;
import org.fulib.fx.util.FrameworkUtil;

public class Modals {
    private static final String MODAL_STAGE = "fulibFx.stage.isModal";
    FulibFxApp app;

    @Inject
    public Modals(FulibFxApp app) {
        this.app = app;
    }

    public <T extends Parent> ModalBuilder<T> modal(T component) {
        if (!ControllerUtil.isComponent(component)) {
            throw new IllegalArgumentException(FrameworkUtil.error(1000));
        }
        return new ModalBuilder<T>(this.app, component);
    }

    public static List<Stage> getModalStages() {
        return Window.getWindows().stream().filter(Modals::isModal).map(window -> (Stage)window).toList();
    }

    public static boolean isModal(Window window) {
        return Boolean.parseBoolean(String.valueOf(window.getProperties().get((Object)MODAL_STAGE)));
    }

    public static class ModalBuilder<T extends Parent> {
        private final BiConsumer<Stage, T> FULIBFX_DIALOG = (modalStage, component) -> {
            modalStage.getScene().setFill(Paint.valueOf((String)"transparent"));
            modalStage.initStyle(StageStyle.TRANSPARENT);
            modalStage.initModality(Modality.WINDOW_MODAL);
            modalStage.setAlwaysOnTop(true);
        };
        private final T component;
        private final FulibFxApp app;
        private BiConsumer<Stage, T> initializer;
        private Stage owner;
        private Map<String, Object> params;
        private boolean destroyOnClose = true;
        private boolean dialog = false;

        public ModalBuilder(FulibFxApp app, T component2) {
            this.app = app;
            this.component = component2;
            this.owner = app.stage();
        }

        public ModalBuilder<T> init(BiConsumer<Stage, T> initializer) {
            if (this.initializer == null) {
                this.initializer = initializer;
                return this;
            }
            this.initializer = this.initializer.andThen(initializer);
            return this;
        }

        public ModalBuilder<T> owner(Stage owner) {
            this.owner = owner;
            return this;
        }

        public ModalBuilder<T> dialog(boolean dialog) {
            this.dialog = dialog;
            return this;
        }

        public ModalBuilder<T> params(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public ModalBuilder<T> destroyOnClose(boolean destroyOnClose) {
            this.destroyOnClose = destroyOnClose;
            return this;
        }

        public Stage build() {
            if (this.component.getScene() != null) {
                throw new RuntimeException(FrameworkUtil.error(1014));
            }
            Stage modalStage = new Stage();
            modalStage.getProperties().put((Object)Modals.MODAL_STAGE, (Object)true);
            if (this.destroyOnClose) {
                modalStage.addEventHandler(WindowEvent.WINDOW_HIDING, event -> this.app.frameworkComponent().controllerManager().destroy(this.component));
            }
            HashMap<String, Object> parameters = this.params == null ? new HashMap<String, Object>() : new HashMap<String, Object>(this.params);
            parameters.putIfAbsent("modalStage", modalStage);
            parameters.putIfAbsent("ownerStage", this.owner);
            this.app.frameworkComponent().controllerManager().init(this.component, parameters);
            Node rendered = this.app.frameworkComponent().controllerManager().render(this.component, parameters);
            if (!(rendered instanceof Parent)) {
                throw new IllegalArgumentException(FrameworkUtil.error(1011).formatted(this.component.getClass().getName()));
            }
            Parent parent = (Parent)rendered;
            this.app.applyTitle(this.component, modalStage);
            Scene scene = new Scene(parent);
            modalStage.setScene(scene);
            modalStage.initOwner((Window)this.owner);
            if (this.dialog) {
                this.FULIBFX_DIALOG.accept(modalStage, (Stage)this.component);
            }
            if (this.initializer != null) {
                this.initializer.accept(modalStage, (Stage)this.component);
            }
            return modalStage;
        }

        public Stage show() {
            Stage modalStage = this.build();
            modalStage.show();
            modalStage.requestFocus();
            return modalStage;
        }
    }
}

