/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.constructs.listview;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javax.inject.Provider;
import org.fulib.fx.FulibFxApp;
import org.fulib.fx.constructs.ReusableItemComponent;

public class ComponentListCell<Item, Component extends Parent>
extends ListCell<Item> {
    private final FulibFxApp app;
    private final Provider<? extends Component> provider;
    private final Map<String, Object> extraParams;
    private Component component;

    public ComponentListCell(FulibFxApp app, Provider<? extends Component> provider) {
        this(app, provider, Map.of());
    }

    public ComponentListCell(FulibFxApp app, Provider<? extends Component> provider, Map<String, Object> extraParams) {
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.app = app;
        this.provider = provider;
        this.extraParams = extraParams;
    }

    protected void updateItem(Item item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            if (this.component != null) {
                this.app.destroy(this.component);
                this.component = null;
            }
            this.setGraphic(null);
            return;
        }
        if (this.component != null && !(this.component instanceof ReusableItemComponent)) {
            this.app.destroy(this.component);
            this.component = null;
        }
        if (this.component == null) {
            this.component = (Parent)this.provider.get();
            HashMap<String, Object> params = new HashMap<String, Object>(this.extraParams);
            params.putIfAbsent("item", item);
            params.putIfAbsent("list", this.getListView().getItems());
            this.setGraphic((Node)this.app.initAndRender(this.component, (Map<String, Object>)params));
        }
        if (this.component instanceof ReusableItemComponent) {
            ((ReusableItemComponent)this.component).setItem(item);
        }
    }
}

