/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller;

import dagger.Lazy;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.util.Pair;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.fulib.fx.annotation.Route;
import org.fulib.fx.controller.ControllerManager;
import org.fulib.fx.data.Either;
import org.fulib.fx.data.EvictingQueue;
import org.fulib.fx.data.SizeableTraversableQueue;
import org.fulib.fx.data.TraversableNodeTree;
import org.fulib.fx.data.TraversableTree;
import org.fulib.fx.util.ControllerUtil;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.reflection.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class Router {
    private final TraversableTree<Provider<?>> routes = new TraversableNodeTree();
    private final SizeableTraversableQueue<Pair<Either<TraversableNodeTree.Node<Provider<?>>, Object>, Map<String, Object>>> history = new EvictingQueue(5);
    @Inject
    Lazy<ControllerManager> manager;
    private Object routerObject;

    @Inject
    public Router() {
    }

    public void registerRoutes(@NotNull Object routes) {
        if (this.routerObject != null) {
            throw new IllegalStateException(FrameworkUtil.error(3000).formatted(this.routerObject.getClass().getName()));
        }
        this.routerObject = routes;
        Reflection.getFieldsWithAnnotation(routes.getClass(), Route.class).forEach(this::registerRoute);
    }

    public boolean routesRegistered() {
        return this.routerObject != null;
    }

    private void registerRoute(@NotNull Field field) {
        if (!field.isAnnotationPresent(Route.class)) {
            throw new RuntimeException(FrameworkUtil.error(3001).formatted(field.getName()));
        }
        ControllerUtil.requireControllerProvider(field);
        Route annotation = field.getAnnotation(Route.class);
        Object route = annotation.value().equals("$name") ? "/" + field.getName() : annotation.value();
        try {
            field.setAccessible(true);
            Provider provider = (Provider)field.get(this.routerObject);
            this.registerRoute((String)route, provider);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerRoute(@NotNull String route, @NotNull Provider<?> provider) {
        route = ((String)route).startsWith("/") ? route : "/" + (String)route;
        this.checkDuplicatedRoute((String)route, provider);
        this.routes.insert((String)route, provider);
    }

    private void checkDuplicatedRoute(String route, Provider<?> provider) {
        if (this.routes.containsPath(route)) {
            Object oldController = this.routes.get(route).get();
            throw new RuntimeException(FrameworkUtil.error(3002).formatted(route, oldController == null ? "null" : oldController.getClass().getName()));
        }
    }

    private void checkContainsRoute(String route) {
        if (!this.routes.containsPath(route)) {
            Object message = FrameworkUtil.error(3005).formatted(route);
            if (this.routes.containsPath("/" + route)) {
                message = (String)message + " " + FrameworkUtil.note(3005).formatted("/" + route);
            }
            throw new RuntimeException((String)message);
        }
    }

    @NotNull
    public Pair<Object, Parent> renderRoute(@NotNull String route, @NotNull @NotNull Map<@NotNull String, @Nullable Object> parameters) {
        this.checkContainsRoute(route);
        Provider<?> provider = this.routes.traverse(route);
        TraversableNodeTree.Node node = ((TraversableNodeTree)this.routes).currentNode();
        this.addToHistory(new Pair(Either.left(node), parameters));
        Object controllerInstance = provider.get();
        Class<?> controllerClass = controllerInstance.getClass();
        if (!ControllerUtil.isControllerOrComponent(controllerClass)) {
            throw new RuntimeException(FrameworkUtil.error(1001).formatted(controllerClass.getName()));
        }
        Node renderedNode = ((ControllerManager)this.manager.get()).initAndRender(controllerInstance, parameters);
        if (renderedNode instanceof Parent) {
            Parent parent = (Parent)renderedNode;
            return new Pair(controllerInstance, (Object)parent);
        }
        throw new RuntimeException(FrameworkUtil.error(1011).formatted(controllerClass.getName()));
    }

    public Object getRoute(String route) {
        String absoluteRoute = this.absolute(route);
        this.checkContainsRoute(absoluteRoute);
        Provider<?> provider = this.routes.get(absoluteRoute);
        return provider.get();
    }

    private String absolute(String route) {
        return route.startsWith("/") ? route : "/" + route;
    }

    public boolean containsRoute(String route) {
        return this.routes.containsPath(this.absolute(route));
    }

    public void addToHistory(Pair<Either<TraversableNodeTree.Node<Provider<?>>, Object>, Map<String, Object>> pair) {
        this.history.insert(pair);
    }

    public Pair<Object, Node> back() {
        try {
            Pair pair = (Pair)this.history.back();
            return this.navigate(pair);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Pair<Object, Node> forward() {
        try {
            Pair pair = (Pair)this.history.forward();
            return this.navigate(pair);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Pair<Object, Node> navigate(Pair<Either<TraversableNodeTree.Node<Provider<?>>, Object>, Map<String, Object>> pair) {
        Either either = (Either)pair.getKey();
        either.getLeft().ifPresent(node -> ((TraversableNodeTree)this.routes).setCurrentNode(node));
        Object controller = either.isLeft() ? Objects.requireNonNull((Provider)((TraversableNodeTree.Node)either.getLeft().orElseThrow()).value()).get() : either.getRight().orElseThrow();
        ((ControllerManager)this.manager.get()).cleanup();
        return new Pair(controller, (Object)((ControllerManager)this.manager.get()).initAndRender(controller, (Map)pair.getValue()));
    }

    public Pair<Object, Map<String, Object>> current() {
        Either either = (Either)((Pair)this.history.current()).getKey();
        return new Pair(either.isLeft() ? either.getLeft().map(node -> Objects.requireNonNull((Provider)node.value())).orElseThrow() : either.getRight().orElseThrow(), (Object)((Map)((Pair)this.history.current()).getValue()));
    }

    public void setHistorySize(int size) {
        this.history.setSize(size);
    }

    public String toString() {
        return "Router(\n" + String.valueOf(this.routes) + "\n)";
    }
}

