/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller.building;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import javax.inject.Provider;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.SubComponent;
import org.fulib.fx.controller.building.ControllerProxyBuilder;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.ReflectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ControllerBuildFactory
implements BuilderFactory {
    private final Object instance;
    private final Map<Class<?>, List<Object>> subComponentInstances;
    private final Map<Class<?>, Provider<?>> subComponentProviders;

    public ControllerBuildFactory(@NotNull Object instance) {
        this.instance = instance;
        this.subComponentInstances = new HashMap();
        this.subComponentProviders = new HashMap();
        this.initSubComponents();
    }

    private void initSubComponents() {
        ReflectionUtil.getAllNonPrivateFieldsOrThrow(this.instance.getClass(), SubComponent.class).forEach(field -> {
            if (field.getType() == Provider.class) {
                field.setAccessible(true);
                try {
                    Class<?> type = ReflectionUtil.getProvidedClass(field);
                    if (type == null) {
                        throw new RuntimeException(FrameworkUtil.error(6006).formatted(field.getName(), field.getClass().getName()));
                    }
                    if (this.subComponentProviders.containsKey(type)) {
                        throw new RuntimeException(FrameworkUtil.error(6000).formatted(type.getName(), this.instance.getClass()));
                    }
                    this.subComponentProviders.put(type, (Provider)field.get(this.instance));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(FrameworkUtil.error(6001).formatted(field.getName(), field.getClass().getName()), e);
                }
                return;
            }
            if (!this.subComponentInstances.containsKey(field.getType())) {
                this.subComponentInstances.put(field.getType(), new ArrayList());
            }
            try {
                field.setAccessible(true);
                this.subComponentInstances.get(field.getType()).add(field.get(this.instance));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(FrameworkUtil.error(6002).formatted(field.getName(), field.getClass().getName()), e);
            }
        });
    }

    public Builder<?> getBuilder(Class<?> type) {
        if (type.isAnnotationPresent(Component.class)) {
            return new ControllerProxyBuilder(this, type);
        }
        return null;
    }

    public Object getProvidedInstance(Class<?> type) {
        if (this.subComponentInstances.containsKey(type)) {
            if (!this.subComponentInstances.get(type).isEmpty()) {
                Object instance = this.subComponentInstances.get(type).get(0);
                this.subComponentInstances.get(type).remove(0);
                return instance;
            }
            throw new RuntimeException(FrameworkUtil.error(6003).formatted(type.getName(), this.instance.getClass()));
        }
        if (this.subComponentProviders.containsKey(type)) {
            return this.subComponentProviders.get(type).get();
        }
        throw new RuntimeException(FrameworkUtil.error(6004).formatted(type.getName(), this.instance.getClass()));
    }
}

