/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.mockups;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import org.fulib.mockups.Element;
import org.fulib.mockups.Page;

public class Content {
    public static final String PROPERTY_id = "id";
    private String id;
    public static final String PROPERTY_description = "description";
    private String description;
    public static final String PROPERTY_value = "value";
    private String value;
    public static final ArrayList<Element> EMPTY_elements = new ArrayList<Element>(){

        @Override
        public boolean add(Element value) {
            throw new UnsupportedOperationException("No direct add! Use xy.withElements(obj)");
        }
    };
    public static final String PROPERTY_elements = "elements";
    private ArrayList<Element> elements = null;
    public static final String PROPERTY_Page = "Page";
    private Page Page = null;
    protected PropertyChangeSupport listeners = null;

    public String getId() {
        return this.id;
    }

    public Content setId(String value) {
        if (value == null ? this.id != null : !value.equals(this.id)) {
            String oldValue = this.id;
            this.id = value;
            this.firePropertyChange(PROPERTY_id, oldValue, value);
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Content setDescription(String value) {
        if (value == null ? this.description != null : !value.equals(this.description)) {
            String oldValue = this.description;
            this.description = value;
            this.firePropertyChange(PROPERTY_description, oldValue, value);
        }
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Content setValue(String value) {
        if (value == null ? this.value != null : !value.equals(this.value)) {
            String oldValue = this.value;
            this.value = value;
            this.firePropertyChange(PROPERTY_value, oldValue, value);
        }
        return this;
    }

    public ArrayList<Element> getElements() {
        if (this.elements == null) {
            return EMPTY_elements;
        }
        return this.elements;
    }

    public Content withElements(Object ... value) {
        if (value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withElements(i);
                }
                continue;
            }
            if (item instanceof Element) {
                if (this.elements == null) {
                    this.elements = new ArrayList();
                }
                if (this.elements.contains(item)) continue;
                this.elements.add((Element)item);
                ((Element)item).setContent(this);
                this.firePropertyChange(PROPERTY_elements, null, item);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Content withoutElements(Object ... value) {
        if (this.elements == null || value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withoutElements(i);
                }
                continue;
            }
            if (!(item instanceof Element) || !this.elements.contains(item)) continue;
            this.elements.remove((Element)item);
            ((Element)item).setContent(null);
            this.firePropertyChange(PROPERTY_elements, item, null);
        }
        return this;
    }

    public Page getPage() {
        return this.Page;
    }

    public Content setPage(Page value) {
        if (this.Page != value) {
            Page oldValue = this.Page;
            if (this.Page != null) {
                this.Page = null;
                oldValue.withoutContent(this);
            }
            this.Page = value;
            if (value != null) {
                value.withContent(this);
            }
            this.firePropertyChange(PROPERTY_Page, oldValue, value);
        }
        return this;
    }

    public boolean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listeners != null) {
            this.listeners.firePropertyChange(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    public boolean addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(listener);
        return true;
    }

    public boolean addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyName, listener);
        return true;
    }

    public boolean removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(listener);
        }
        return true;
    }

    public boolean removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(propertyName, listener);
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getId());
        result.append(" ").append(this.getDescription());
        result.append(" ").append(this.getValue());
        return result.substring(1);
    }

    public void removeYou() {
        this.setPage(null);
        this.withoutElements(this.getElements().clone());
    }
}

