/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.mockups;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import spark.Request;
import spark.Response;
import spark.Service;

public class FulibService {
    private Object app;

    public FulibService setApp(Object app) {
        this.app = app;
        return this;
    }

    public FulibService start() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Service spark = Service.ignite();
        spark.port(45678);
        spark.get("/:cmd", (request, response) -> executor.submit(() -> this.getPage(request, response)).get());
        return this;
    }

    private String getPage(Request req, Response res) {
        try {
            String cmd = req.params(":cmd");
            if (cmd == null) {
                return "";
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            int dollarIndex = cmd.indexOf(36);
            if (dollarIndex > 0) {
                String dollarParam = cmd.substring(dollarIndex + 1);
                params.put("$", dollarParam);
                cmd = cmd.substring(0, dollarIndex);
            }
            for (String param : req.queryParams()) {
                String value = req.queryParams(param);
                params.put(param, value);
            }
            Class<?> appClass = this.app.getClass();
            Method method = appClass.getMethod(cmd, Map.class);
            return (String)method.invoke(this.app, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }
}

