/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.mockups;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fulib.mockups.UI;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class UIRenderer {
    private static final STGroupFile HTML_TEMPLATES = new STGroupFile(UIRenderer.class.getResource("html.stg"));
    private static final Map<String, Renderer> RENDERERS;
    private Map<String, String> params;

    public static String render(UI page, Map<String, String> params) {
        return new UIRenderer().setParams(params).renderPage(page);
    }

    private UIRenderer setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    private String renderPage(UI page) {
        String content = this.render(page);
        ST st = HTML_TEMPLATES.getInstanceOf("page");
        st.add("root", (Object)page.getId());
        st.add("content", (Object)content);
        return st.render();
    }

    private String render(UI ui) {
        StringBuilder builder = new StringBuilder();
        this.render(ui, builder);
        return builder.toString();
    }

    private void render(UI ui, StringBuilder out) {
        String description = ui.getDescription();
        if (description != null) {
            for (String descriptionItem : description.split("\n|\\|\\|")) {
                String text = this.getDivContent(descriptionItem);
                ST st = HTML_TEMPLATES.getInstanceOf("div");
                st.add("type", (Object)"line");
                st.add("content", (Object)text);
                out.append(st.render());
            }
        }
        for (UI kid : ui.getContent()) {
            this.render(kid, out);
            out.append("\n");
        }
    }

    private String getDivContent(String description) {
        StringBuilder text = new StringBuilder();
        for (String elem : description.split("\\|")) {
            String[] args = elem.trim().split(" ");
            if (args.length == 0) continue;
            Renderer renderer = RENDERERS.get(args[0]);
            if (renderer != null) {
                text.append(renderer.render(args, this.params));
                continue;
            }
            text.append(elem).append('\n');
        }
        return text.toString();
    }

    private static String renderButton(String[] args, Map<String, String> params) {
        String buttonText = args[1];
        String target = args.length > 2 ? args[2] : buttonText;
        ST st = HTML_TEMPLATES.getInstanceOf("button");
        st.add("text", (Object)buttonText);
        st.add("target", (Object)target);
        return st.render();
    }

    private static String renderHidden(String[] args, Map<String, String> params) {
        String name = args[1];
        String value = args.length > 2 ? args[2] : params.get(name);
        ST st = HTML_TEMPLATES.getInstanceOf("hidden");
        st.add("name", (Object)name);
        st.add("value", (Object)value);
        return st.render();
    }

    private static String renderInput(String[] args, Map<String, String> params) {
        String inputName = args[1];
        String prompt = args[2];
        String value = params.get(inputName);
        ST st = HTML_TEMPLATES.getInstanceOf("input");
        st.add("id", (Object)inputName);
        st.add("prompt", (Object)prompt);
        st.add("value", (Object)value);
        return st.render();
    }

    private static String renderCell(String[] args, Map<String, String> params) {
        ST st = HTML_TEMPLATES.getInstanceOf("cell");
        st.add("text", (Object)args[1]);
        return st.render();
    }

    private static String renderLine(String[] args, Map<String, String> params) {
        return "<hr/>\n";
    }

    static {
        HashMap<String, Renderer> renderers = new HashMap<String, Renderer>();
        renderers.put("button", UIRenderer::renderButton);
        renderers.put("hidden", UIRenderer::renderHidden);
        renderers.put("input", UIRenderer::renderInput);
        renderers.put("cell", UIRenderer::renderCell);
        renderers.put("---", UIRenderer::renderLine);
        RENDERERS = Collections.unmodifiableMap(renderers);
    }

    static interface Renderer {
        public String render(String[] var1, Map<String, String> var2);
    }
}

