/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.service;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.fulib.scenarios.MockupTools;
import org.fulib.yaml.StrUtil;
import org.fulib.yaml.YamlIdMap;

public class Service {
    private HttpServer server;
    private ExecutorService executor;
    private Object webApp;
    private YamlIdMap idMap;

    public static void main(String[] args) {
        String webAppClassName = "webapp.WebApp";
        if (args != null && args.length > 0) {
            webAppClassName = args[0];
        }
        new Service().start(webAppClassName);
    }

    private void start(String webAppClassName) {
        try {
            Class<?> webAppClass = this.getClass().getClassLoader().loadClass(webAppClassName);
            this.webApp = webAppClass.newInstance();
            Method init = webAppClass.getMethod("init", new Class[0]);
            init.invoke(this.webApp, new Object[0]);
            this.idMap = new YamlIdMap(this.webApp.getClass().getPackage().getName());
            this.server = HttpServer.create(new InetSocketAddress(6677), 0);
            this.executor = Executors.newSingleThreadExecutor();
            this.server.setExecutor(this.executor);
            HttpContext doContext = this.server.createContext("/");
            doContext.setHandler(x -> this.handleRoot(x));
            HttpContext initContext = this.server.createContext("/index.html");
            initContext.setHandler(x -> this.handleRoot(x));
            HttpContext cmdContext = this.server.createContext("/cmd");
            cmdContext.setHandler(x -> this.handleCmd(x));
            this.server.start();
            System.out.println("Server is listening on port 6677");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleCmd(HttpExchange x) {
        String cmd = Service.getBody(x);
        ArrayList<String> params = this.getParamsList(cmd);
        String packageName = this.webApp.getClass().getPackage().getName();
        if (params.size() > 2 || !params.get(0).equals(params.get(params.size() - 1))) {
            this.callButtonAction(params, packageName);
        }
        this.callNewPage(params.get(params.size() - 1));
        this.handleRoot(x);
    }

    private void callNewPage(String param) {
        try {
            param = StrUtil.downFirstChar((String)param);
            Method method = this.webApp.getClass().getMethod(param, new Class[0]);
            method.invoke(this.webApp, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("could not find page method " + param);
        }
    }

    private void callButtonAction(ArrayList<String> params, String packageName) {
        Method[] methods;
        String cmdName = params.get(0);
        for (Method method : methods = this.webApp.getClass().getMethods()) {
            String methodName = method.getName();
            if (!method.getName().startsWith(cmdName)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            ArrayList<Object> actualParamsList = new ArrayList<Object>();
            int i = 0;
            for (Class<?> parameterType : parameterTypes) {
                ++i;
                String paramTypeName = parameterType.getName();
                if (paramTypeName.startsWith(packageName)) {
                    String simpleName = parameterType.getSimpleName();
                    String objId = params.get(i);
                    String findMethodName = "find" + simpleName;
                    Object object = null;
                    try {
                        Method findMethod = this.webApp.getClass().getMethod(findMethodName, String.class);
                        object = findMethod.invoke(this.webApp, objId);
                    }
                    catch (Exception e) {
                        object = this.idMap.decode("- " + objId + ": " + simpleName + " id: " + objId + " name: " + objId);
                    }
                    actualParamsList.add(object);
                    continue;
                }
                if (paramTypeName.equals("int")) {
                    Integer value = Integer.valueOf(params.get(i));
                    actualParamsList.add(value);
                    continue;
                }
                if (paramTypeName.equals("java.lang.String")) {
                    actualParamsList.add(params.get(i));
                    continue;
                }
                System.out.println("Do not know how to handle param of type " + paramTypeName);
            }
            try {
                method.invoke(this.webApp, actualParamsList.toArray());
                return;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        System.err.println("could not find action method " + cmdName);
    }

    private ArrayList<String> getParamsList(String cmd) {
        ArrayList<String> cmdMap = new ArrayList<String>();
        if (cmd.startsWith("{")) {
            String[] split;
            String content = cmd.substring(1, cmd.lastIndexOf(125));
            for (String pair : split = content.split(",")) {
                String[] keyValue = pair.split(":");
                String key = keyValue[0];
                key = key.substring(1, key.length() - 1);
                String value = keyValue[1];
                value = value.substring(1, value.length() - 1);
                cmdMap.add(value);
            }
        }
        return cmdMap;
    }

    private LinkedHashMap<String, String> getParamsMap(String cmd) {
        LinkedHashMap<String, String> cmdMap = new LinkedHashMap<String, String>();
        if (cmd.startsWith("{")) {
            String[] split;
            String content = cmd.substring(1, cmd.lastIndexOf(125));
            for (String pair : split = content.split(",")) {
                String[] keyValue = pair.split(":");
                String key = keyValue[0];
                key = key.substring(1, key.length() - 1);
                String value = keyValue[1];
                value = value.substring(1, value.length() - 1);
                cmdMap.put(key, value);
            }
        }
        return cmdMap;
    }

    public static String getBody(HttpExchange exchange) {
        try {
            String line;
            URI requestURI = exchange.getRequestURI();
            InputStream requestBody = exchange.getRequestBody();
            BufferedReader buf = new BufferedReader(new InputStreamReader(requestBody, StandardCharsets.UTF_8));
            StringBuilder text = new StringBuilder();
            while ((line = buf.readLine()) != null) {
                text.append(line).append("\n");
            }
            String yaml = text.toString();
            return yaml;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void writeAnswer(HttpExchange x, String page) {
        try {
            byte[] bytes = page.getBytes();
            x.sendResponseHeaders(200, bytes.length);
            x.getResponseBody().write(bytes);
            x.getResponseBody().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleRoot(HttpExchange x) {
        try {
            StringWriter stringWriter = new StringWriter();
            MockupTools.htmlTool().dumpScreen(stringWriter, this.webApp);
            String page = stringWriter.toString();
            this.writeAnswer(x, page);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

