/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.mockups;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import org.fulib.mockups.Parameter;
import org.fulib.mockups.UI;
import org.fulib.mockups.UIRenderer;
import org.openqa.selenium.OutputType;

public class MockupTool {
    public void dump(String file, UI page) {
        String pngFile;
        String htmlFile;
        if (file.endsWith(".html.png")) {
            htmlFile = file.substring(0, file.length() - ".png".length());
            pngFile = file;
        } else if (file.endsWith(".png")) {
            htmlFile = null;
            pngFile = file;
        } else if (file.endsWith(".html")) {
            htmlFile = file;
            pngFile = null;
        } else {
            throw new IllegalArgumentException("invalid file name '" + file + "' - extension must be .html.png, .png or .html");
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Parameter param : page.getParameters()) {
            params.put(param.getKey(), param.getValue());
        }
        String html = UIRenderer.render(page, params);
        if (htmlFile != null) {
            MockupTool.writeHtmlFile(htmlFile, html);
        }
        if (pngFile != null) {
            MockupTool.writePngFile(pngFile, html);
        }
    }

    private static void writeHtmlFile(String htmlFile, String html) {
        Path path = Paths.get(htmlFile, new String[0]);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, html.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writePngFile(String pngFile, String html) {
        Configuration.browserSize = "640x480";
        Configuration.headless = true;
        Configuration.savePageSource = false;
        String dataUrl = "data:text/html," + html;
        Selenide.open((String)dataUrl);
        File screenshotFile = (File)Selenide.screenshot((OutputType)OutputType.FILE);
        File dest = new File(pngFile);
        dest.delete();
        dest.getParentFile().mkdirs();
        screenshotFile.renameTo(dest);
    }
}

