package org.fulib.scenarios.ast;

import java.util.List;
import org.fulib.scenarios.ast.decl.Name;


public interface MultiDescriptor extends Node
{
	// =============== Static Methods ===============
	static MultiDescriptor of(Name type, List<String> names, List<NamedExpr> attributes) { return new Impl(type, names, attributes); }
	// =============== Properties ===============
	Name getType();
	void setType(Name type);
	List<String> getNames();
	void setNames(List<String> names);
	List<NamedExpr> getAttributes();
	void setAttributes(List<NamedExpr> attributes);

	// =============== Methods ===============
	<P, R> R accept(MultiDescriptor.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements MultiDescriptor
	{
		// =============== Fields ===============
		private Name type;
		private List<String> names;
		private List<NamedExpr> attributes;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(Name type, List<String> names, List<NamedExpr> attributes)
		{
			this.type = type;
			this.names = names;
			this.attributes = attributes;
		}

		// =============== Properties ===============
		@Override public Name getType() { return this.type; }
		@Override public void setType(Name type) { this.type = type; }
		@Override public List<String> getNames() { return this.names; }
		@Override public void setNames(List<String> names) { this.names = names; }
		@Override public List<NamedExpr> getAttributes() { return this.attributes; }
		@Override public void setAttributes(List<NamedExpr> attributes) { this.attributes = attributes; }

		// =============== Methods ===============
		@Override public <P, R> R accept(MultiDescriptor.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(MultiDescriptor multiDescriptor, P par);
	}
}
