package org.fulib.scenarios.ast;

import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.expr.Expr;


public interface NamedExpr extends Node
{
	// =============== Static Methods ===============
	static NamedExpr of(Name name, Expr expr) { return new Impl(name, expr); }
	// =============== Properties ===============
	Name getName();
	void setName(Name name);
	Expr getExpr();
	void setExpr(Expr expr);

	// =============== Methods ===============
	<P, R> R accept(NamedExpr.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements NamedExpr
	{
		// =============== Fields ===============
		private Name name;
		private Expr expr;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(Name name, Expr expr)
		{
			this.name = name;
			this.expr = expr;
		}

		// =============== Properties ===============
		@Override public Name getName() { return this.name; }
		@Override public void setName(Name name) { this.name = name; }
		@Override public Expr getExpr() { return this.expr; }
		@Override public void setExpr(Expr expr) { this.expr = expr; }

		// =============== Methods ===============
		@Override public <P, R> R accept(NamedExpr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(NamedExpr namedExpr, P par);
	}
}
