package org.fulib.scenarios.ast;

import java.util.Map;
import org.fulib.scenarios.ast.decl.ClassDecl;


public interface ScenarioGroup extends Node
{
	// =============== Static Methods ===============
	static ScenarioGroup of(String sourceDir, String packageDir, Map<String, ScenarioFile> files, Map<String, ClassDecl> classes) { return new Impl(sourceDir, packageDir, files, classes); }
	// =============== Properties ===============
	String getSourceDir();
	void setSourceDir(String sourceDir);
	String getPackageDir();
	void setPackageDir(String packageDir);
	Map<String, ScenarioFile> getFiles();
	void setFiles(Map<String, ScenarioFile> files);
	Map<String, ClassDecl> getClasses();
	void setClasses(Map<String, ClassDecl> classes);

	// =============== Methods ===============
	<P, R> R accept(ScenarioGroup.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements ScenarioGroup
	{
		// =============== Fields ===============
		private String sourceDir;
		private String packageDir;
		private Map<String, ScenarioFile> files;
		private Map<String, ClassDecl> classes;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(String sourceDir, String packageDir, Map<String, ScenarioFile> files, Map<String, ClassDecl> classes)
		{
			this.sourceDir = sourceDir;
			this.packageDir = packageDir;
			this.files = files;
			this.classes = classes;
		}

		// =============== Properties ===============
		@Override public String getSourceDir() { return this.sourceDir; }
		@Override public void setSourceDir(String sourceDir) { this.sourceDir = sourceDir; }
		@Override public String getPackageDir() { return this.packageDir; }
		@Override public void setPackageDir(String packageDir) { this.packageDir = packageDir; }
		@Override public Map<String, ScenarioFile> getFiles() { return this.files; }
		@Override public void setFiles(Map<String, ScenarioFile> files) { this.files = files; }
		@Override public Map<String, ClassDecl> getClasses() { return this.classes; }
		@Override public void setClasses(Map<String, ClassDecl> classes) { this.classes = classes; }

		// =============== Methods ===============
		@Override public <P, R> R accept(ScenarioGroup.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(ScenarioGroup scenarioGroup, P par);
	}
}
