package org.fulib.scenarios.ast.expr.call;

import java.util.List;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.expr.Expr;


public interface CreationExpr extends Expr
{
	// =============== Static Methods ===============
	static CreationExpr of(Name className, List<NamedExpr> attributes) { return new Impl(className, attributes); }
	// =============== Properties ===============
	Name getClassName();
	void setClassName(Name className);
	List<NamedExpr> getAttributes();
	void setAttributes(List<NamedExpr> attributes);

	// =============== Methods ===============
	<P, R> R accept(CreationExpr.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements CreationExpr
	{
		// =============== Fields ===============
		private Name className;
		private List<NamedExpr> attributes;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(Name className, List<NamedExpr> attributes)
		{
			this.className = className;
			this.attributes = attributes;
		}

		// =============== Properties ===============
		@Override public Name getClassName() { return this.className; }
		@Override public void setClassName(Name className) { this.className = className; }
		@Override public List<NamedExpr> getAttributes() { return this.attributes; }
		@Override public void setAttributes(List<NamedExpr> attributes) { this.attributes = attributes; }

		// =============== Methods ===============
		@Override public <P, R> R accept(CreationExpr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Expr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(CreationExpr creationExpr, P par);
	}
}
