package org.fulib.scenarios.ast.expr.collection;

import java.util.List;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.expr.Expr;


public interface ListExpr extends CollectionExpr
{
	// =============== Static Methods ===============
	static ListExpr of(List<Expr> elements) { return new Impl(elements); }
	// =============== Properties ===============
	List<Expr> getElements();
	void setElements(List<Expr> elements);

	// =============== Methods ===============
	<P, R> R accept(ListExpr.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements ListExpr
	{
		// =============== Fields ===============
		private List<Expr> elements;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(List<Expr> elements)
		{
			this.elements = elements;
		}

		// =============== Properties ===============
		@Override public List<Expr> getElements() { return this.elements; }
		@Override public void setElements(List<Expr> elements) { this.elements = elements; }

		// =============== Methods ===============
		@Override public <P, R> R accept(ListExpr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(CollectionExpr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Expr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(ListExpr listExpr, P par);
	}
}
