package org.fulib.scenarios.ast.expr.primary;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.expr.Expr;


public interface NameAccess extends PrimaryExpr
{
	// =============== Static Methods ===============
	static NameAccess of(Name name) { return new Impl(name); }
	// =============== Properties ===============
	Name getName();
	void setName(Name name);

	// =============== Methods ===============
	<P, R> R accept(NameAccess.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements NameAccess
	{
		// =============== Fields ===============
		private Name name;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(Name name)
		{
			this.name = name;
		}

		// =============== Properties ===============
		@Override public Name getName() { return this.name; }
		@Override public void setName(Name name) { this.name = name; }

		// =============== Methods ===============
		@Override public <P, R> R accept(NameAccess.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(PrimaryExpr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Expr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(NameAccess nameAccess, P par);
	}
}
