package org.fulib.scenarios.ast.expr.primary;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.expr.Expr;


public interface StringLiteral extends PrimaryExpr
{
	// =============== Static Methods ===============
	static StringLiteral of(String value) { return new Impl(value); }
	// =============== Properties ===============
	String getValue();
	void setValue(String value);

	// =============== Methods ===============
	<P, R> R accept(StringLiteral.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements StringLiteral
	{
		// =============== Fields ===============
		private String value;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(String value)
		{
			this.value = value;
		}

		// =============== Properties ===============
		@Override public String getValue() { return this.value; }
		@Override public void setValue(String value) { this.value = value; }

		// =============== Methods ===============
		@Override public <P, R> R accept(StringLiteral.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(PrimaryExpr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Expr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(StringLiteral stringLiteral, P par);
	}
}
