/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.fulib.FulibTools;
import org.fulib.Generator;
import org.fulib.builder.ClassModelManager;
import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.FMethod;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.codegen.DeclGenerator;
import org.fulib.scenarios.tool.Config;
import org.fulib.scenarios.transform.SymbolCollector;

public class CodeGenerator
implements ScenarioGroup.Visitor<Object, Object>,
ScenarioFile.Visitor<Object, Object> {
    final Config config;
    ScenarioGroup group;
    ClassModelManager modelManager;
    Clazz clazz;
    FMethod method;
    StringBuilder bodyBuilder;

    public CodeGenerator(Config config) {
        this.config = config;
    }

    void emit(String code) {
        this.bodyBuilder.append(code);
    }

    void emitStringLiteral(String text) {
        this.bodyBuilder.append('\"').append(text).append('\"');
    }

    void emitIndent() {
        this.bodyBuilder.append("      ");
    }

    void addImport(String s) {
        this.clazz.getImportList().add("import " + s + ";");
    }

    @Override
    public Object visit(ScenarioGroup scenarioGroup, Object par) {
        this.group = scenarioGroup;
        String modelDir = this.config.getModelDir();
        String packageDir = scenarioGroup.getPackageDir();
        String packageName = packageDir.replace('/', '.');
        this.modelManager = new ClassModelManager().havePackageName(packageName).haveMainJavaDir(modelDir);
        for (ClassDecl classDecl : scenarioGroup.getClasses().values()) {
            classDecl.accept(DeclGenerator.INSTANCE, this);
        }
        new Generator().generate(this.modelManager.getClassModel());
        if (this.config.isClassDiagram()) {
            FulibTools.classDiagrams().dumpPng(this.modelManager.getClassModel(), modelDir + "/" + packageDir + "/classDiagram.png");
        }
        if (this.config.isClassDiagramSVG()) {
            FulibTools.classDiagrams().dumpSVG(this.modelManager.getClassModel(), modelDir + "/" + packageDir + "/classDiagram.svg");
        }
        this.modelManager = new ClassModelManager().havePackageName(packageName).haveMainJavaDir(this.config.getTestDir());
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            file.accept(this, par);
        }
        new Generator().generate(this.modelManager.getClassModel());
        return null;
    }

    @Override
    public Object visit(ScenarioFile scenarioFile, Object par) {
        this.clazz = this.modelManager.haveClass(scenarioFile.getClassDecl().getName());
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            this.addDiagramSentences(scenario);
        }
        scenarioFile.getClassDecl().accept(DeclGenerator.INSTANCE, this);
        this.addImport("org.junit.Test");
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            String methodName = scenario.getMethodDecl().getName();
            CodeGenerator.getFMethod(this.clazz, methodName).setAnnotations("@Test");
        }
        return null;
    }

    private void addDiagramSentences(Scenario scenario) {
        DiagramSentence diagramSentence;
        if (!this.config.isObjectDiagram() && !this.config.isObjectDiagramSVG()) {
            return;
        }
        String methodName = scenario.getMethodDecl().getName();
        List<Sentence> sentences = scenario.getBody().getItems();
        TreeMap symbolTable = new TreeMap();
        for (Sentence item : sentences) {
            item.accept(SymbolCollector.INSTANCE, symbolTable);
        }
        if (symbolTable.isEmpty()) {
            return;
        }
        Map<String, ClassDecl> classes = scenario.getFile().getGroup().getClasses();
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        for (Decl it : symbolTable.values()) {
            if (classes.get(it.getType()) == null) continue;
            exprs.add(NameAccess.of(ResolvedName.of(it)));
        }
        ListExpr listExpr = ListExpr.of(exprs);
        if (this.config.isObjectDiagram()) {
            diagramSentence = DiagramSentence.of(listExpr, methodName + ".png");
            sentences.add(diagramSentence);
        }
        if (this.config.isObjectDiagramSVG()) {
            diagramSentence = DiagramSentence.of(listExpr, methodName + ".svg");
            sentences.add(diagramSentence);
        }
    }

    private static FMethod getFMethod(Clazz clazz, String name) {
        for (FMethod fMethod : clazz.getMethods()) {
            if (!name.equals(fMethod.readName())) continue;
            return fMethod;
        }
        throw new RuntimeException("method " + clazz.getName() + "." + name + " not found");
    }
}

