/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.Tool;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.codegen.CodeGenerator;
import org.fulib.scenarios.parser.ASTListener;
import org.fulib.scenarios.parser.ScenarioLexer;
import org.fulib.scenarios.parser.ScenarioParser;
import org.fulib.scenarios.tool.Config;
import org.fulib.scenarios.tool.ErrorListener;
import org.fulib.scenarios.transform.Desugar;
import org.fulib.scenarios.transform.Grouper;
import org.fulib.scenarios.transform.NameResolver;

public class ScenarioCompiler
implements Tool {
    private static final String TOOL_NAME = "scenarioc";
    private PrintWriter out;
    private PrintWriter err;
    private Config config = new Config();
    private List<ScenarioGroup> groups = new ArrayList<ScenarioGroup>();
    private int errors;

    public PrintWriter getOut() {
        return this.out;
    }

    public void setOut(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getErr() {
        return this.err;
    }

    public void setErr(PrintWriter err) {
        this.err = err;
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return Collections.singleton(SourceVersion.RELEASE_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        this.setOut(new PrintWriter(out));
        this.setErr(new PrintWriter(err));
        try {
            int n = this.run(arguments);
            return n;
        }
        finally {
            this.getOut().flush();
            this.getErr().flush();
        }
    }

    public int run(String[] arguments) {
        CommandLine cmd;
        Options options = this.config.createOptions();
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            cmd = parser.parse(options, arguments);
        }
        catch (ParseException e) {
            this.getErr().println(e.getMessage());
            formatter.printHelp(this.getErr(), formatter.getWidth(), TOOL_NAME, null, options, formatter.getLeftPadding(), formatter.getDescPadding(), null);
            return -1;
        }
        this.config.readOptions(cmd);
        return this.run();
    }

    public int run() {
        this.discover();
        this.groups.forEach(this::processGroup);
        return this.errors;
    }

    private void discover() {
        for (String inputDirName : this.config.getInputDirs()) {
            File inputDir = new File(inputDirName);
            if (!inputDir.exists() || !inputDir.isDirectory()) continue;
            this.discover(inputDir, inputDir, "");
        }
    }

    private void discover(File sourceDir, File dir, String packageDir) {
        HashMap<String, ScenarioFile> scenarioFiles = new HashMap<String, ScenarioFile>();
        for (File file : Objects.requireNonNull(dir.listFiles())) {
            ScenarioFile scenarioFile;
            String fileName = file.getName();
            if (file.isDirectory()) {
                String newPackage = packageDir.isEmpty() ? fileName : packageDir + "/" + fileName;
                this.discover(sourceDir, file, newPackage);
                continue;
            }
            if ("Register.md".equals(fileName) || !fileName.endsWith(".md") || (scenarioFile = this.parseScenario(file)) == null) continue;
            String name = fileName.substring(0, fileName.length() - 3);
            scenarioFile.setName(name);
            scenarioFiles.put(name, scenarioFile);
        }
        if (!scenarioFiles.isEmpty()) {
            ScenarioGroup group = ScenarioGroup.of(sourceDir.toString(), packageDir, scenarioFiles, new HashMap<String, ClassDecl>());
            for (ScenarioFile file : scenarioFiles.values()) {
                file.setGroup(group);
            }
            this.groups.add(group);
        }
    }

    private ScenarioFile parseScenario(File file) {
        CharStream input;
        try {
            input = CharStreams.fromPath((Path)file.toPath());
        }
        catch (IOException e) {
            this.getErr().println("failed to read scenario file " + file);
            e.printStackTrace(this.getErr());
            return null;
        }
        ErrorListener errorListener = new ErrorListener(this.getOut());
        ScenarioLexer lexer = new ScenarioLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        ScenarioParser parser = new ScenarioParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        ScenarioParser.FileContext context = parser.file();
        int syntaxErrors = parser.getNumberOfSyntaxErrors();
        if (syntaxErrors > 0) {
            this.errors += syntaxErrors;
            this.getErr().println(syntaxErrors + " syntax errors in scenario " + file);
            return null;
        }
        try {
            ASTListener listener = new ASTListener();
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)listener, (ParseTree)context);
            this.getErr().println("read scenario " + file);
            return listener.getFile();
        }
        catch (Exception e) {
            this.getErr().println("failed to transform scenario " + file);
            e.printStackTrace(this.getErr());
            return null;
        }
    }

    private void processGroup(ScenarioGroup scenarioGroup) {
        scenarioGroup.accept(Grouper.INSTANCE, null);
        scenarioGroup.accept(new Desugar(), null);
        scenarioGroup.accept(NameResolver.INSTANCE, null);
        scenarioGroup.accept(new CodeGenerator(this.config), null);
    }
}

