/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.tool;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.tools.ToolProvider;
import org.fulib.scenarios.tool.ScenarioCompiler;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class Tools {
    public static boolean isJava(Path file) {
        return file.toString().endsWith(".java");
    }

    public static boolean isClass(Path file) {
        return file.toString().endsWith(".class");
    }

    public static Stream<Path> collectJavaFiles(Path sourceFolder) {
        try {
            return Files.walk(sourceFolder, new FileVisitOption[0]).filter(Tools::isJava);
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }

    public static void deleteRecursively(Path dir) {
        try {
            Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(file -> {
                try {
                    Files.deleteIfExists(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int scenarioc(OutputStream out, OutputStream err, Path scenarioSrcDir, Path modelSrcDir, Path testSrcDir, String ... args) {
        ArrayList<String> finalArgs = new ArrayList<String>(5 + args.length);
        finalArgs.add("-m");
        finalArgs.add(modelSrcDir.toString());
        finalArgs.add("-t");
        finalArgs.add(testSrcDir.toString());
        finalArgs.add(scenarioSrcDir.toString());
        Collections.addAll(finalArgs, args);
        return new ScenarioCompiler().run(null, out, err, finalArgs.toArray(new String[0]));
    }

    public static int javac(String classpath, Path outFolder, Path ... sourceFolders) throws IOException {
        return Tools.javac(null, null, classpath, outFolder, sourceFolders);
    }

    public static int javac(OutputStream out, OutputStream err, String classpath, Path outFolder, Path ... sourceFolders) throws IOException {
        Files.createDirectories(outFolder, new FileAttribute[0]);
        ArrayList<String> args = new ArrayList<String>();
        Arrays.stream(sourceFolders).flatMap(Tools::collectJavaFiles).map(Path::toString).forEach(args::add);
        args.add("-d");
        args.add(outFolder.toString());
        if (classpath != null) {
            args.add("-classpath");
            args.add(classpath);
        }
        return ToolProvider.getSystemJavaCompiler().run(null, out, err, args.toArray(new String[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result runTests(Path mainClassesDir, Path testClassesDir) {
        URL[] classPathUrls = new URL[]{};
        try {
            classPathUrls = new URL[]{mainClassesDir.toUri().toURL(), testClassesDir.toUri().toURL()};
        }
        catch (MalformedURLException e) {
            Logger.getGlobal().log(Level.SEVERE, "could not build classpath", e);
        }
        try (URLClassLoader classLoader = new URLClassLoader(classPathUrls);){
            ArrayList testClasses = new ArrayList();
            Files.walk(testClassesDir, new FileVisitOption[0]).filter(Tools::isClass).sorted().forEach(path -> {
                String relativePath = testClassesDir.relativize((Path)path).toString();
                String className = relativePath.substring(0, relativePath.length() - ".class".length()).replace('/', '.').replace('\\', '.');
                try {
                    Class<?> testClass = Class.forName(className, true, classLoader);
                    testClasses.add(testClass);
                }
                catch (ClassNotFoundException e) {
                    throw new AssertionError(className + " should exist", e);
                }
            });
            Result result = new JUnitCore().run(testClasses.toArray(new Class[0]));
            return result;
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to walk " + testClassesDir.toString(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int genCompileRun(OutputStream out, OutputStream err, Path srcDir, Path modelSrcDir, Path testSrcDir, Path modelClassesDir, Path testClassesDir, String ... scenariocArgs) throws Exception {
        PrintStream printErr = new PrintStream(err, false, StandardCharsets.UTF_8.name());
        try {
            int n;
            Throwable throwable;
            FakeProperty ignored;
            block39: {
                block40: {
                    block36: {
                        int n2;
                        block37: {
                            block38: {
                                String classPath;
                                block33: {
                                    int n3;
                                    block34: {
                                        block35: {
                                            block30: {
                                                int n4;
                                                block31: {
                                                    block32: {
                                                        ignored = new FakeProperty("apply.awt.UIElement", "true");
                                                        throwable = null;
                                                        int scenarioc = Tools.scenarioc(out, err, srcDir, modelSrcDir, testSrcDir, scenariocArgs);
                                                        if (scenarioc == 0) break block30;
                                                        n4 = scenarioc << 2;
                                                        if (ignored == null) break block31;
                                                        if (throwable == null) break block32;
                                                        try {
                                                            ignored.close();
                                                        }
                                                        catch (Throwable throwable2) {
                                                            throwable.addSuppressed(throwable2);
                                                        }
                                                        break block31;
                                                    }
                                                    ignored.close();
                                                }
                                                return n4;
                                            }
                                            classPath = System.getProperty("java.class.path");
                                            int modelJavac = Tools.javac(out, err, classPath, modelClassesDir, modelSrcDir);
                                            if (modelJavac == 0) break block33;
                                            n3 = modelJavac << 2 | 1;
                                            if (ignored == null) break block34;
                                            if (throwable == null) break block35;
                                            try {
                                                ignored.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            break block34;
                                        }
                                        ignored.close();
                                    }
                                    return n3;
                                }
                                String testClassPath = modelClassesDir + File.pathSeparator + classPath;
                                int testJavac = Tools.javac(out, err, testClassPath, testClassesDir, testSrcDir);
                                if (testJavac == 0) break block36;
                                n2 = testJavac << 2 | 2;
                                if (ignored == null) break block37;
                                if (throwable == null) break block38;
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                break block37;
                            }
                            ignored.close();
                        }
                        return n2;
                    }
                    Result testResult = Tools.runTests(modelClassesDir, testClassesDir);
                    for (Failure failure : testResult.getFailures()) {
                        printErr.print(failure.getTestHeader());
                        printErr.println("failed:");
                        failure.getException().printStackTrace(printErr);
                    }
                    int failureCount = testResult.getFailureCount();
                    int n5 = n = failureCount == 0 ? 0 : failureCount << 2 | 3;
                    if (ignored == null) break block39;
                    if (throwable == null) break block40;
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    break block39;
                }
                ignored.close();
            }
            return n;
            catch (Throwable throwable6) {
                try {
                    try {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    catch (Throwable throwable7) {
                        if (ignored != null) {
                            if (throwable != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        throw throwable7;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(printErr);
                    int n6 = -1;
                    return n6;
                }
            }
        }
        finally {
            printErr.flush();
        }
    }

    private static class FakeProperty
    implements AutoCloseable {
        private final String key;
        private final String original;

        public FakeProperty(String key, String newValue) {
            this.key = key;
            this.original = System.getProperty(key);
            System.setProperty(key, newValue);
        }

        @Override
        public void close() {
            if (this.original == null) {
                System.clearProperty(this.key);
            } else {
                System.setProperty(this.key, this.original);
            }
        }
    }
}

