/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.CollectionExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.NumberLiteral;
import org.fulib.scenarios.ast.expr.primary.PrimaryExpr;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.CallSentence;
import org.fulib.scenarios.ast.sentence.CreateSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.ThereSentence;
import org.fulib.scenarios.transform.ExtractDecl;
import org.fulib.scenarios.transform.Namer;
import org.fulib.scenarios.transform.SymbolCollector;
import org.fulib.scenarios.transform.Typer;
import org.fulib.scenarios.transform.scope.DelegatingScope;
import org.fulib.scenarios.transform.scope.HidingScope;
import org.fulib.scenarios.transform.scope.Scope;

public enum NameResolver implements ScenarioGroup.Visitor<Object, Object>,
ScenarioFile.Visitor<Scope, Object>,
Scenario.Visitor<Scope, Object>,
Sentence.Visitor<Scope, Object>,
Expr.Visitor<Scope, Expr>,
Name.Visitor<Scope, Name>
{
    INSTANCE;


    @Override
    public Object visit(final ScenarioGroup scenarioGroup, Object par) {
        Scope scope = new Scope(){

            @Override
            public Decl resolve(String name) {
                return scenarioGroup.getClasses().get(name);
            }

            @Override
            public void add(Decl decl) {
                ClassDecl classDecl = (ClassDecl)decl;
                classDecl.setGroup(scenarioGroup);
                scenarioGroup.getClasses().put(decl.getName(), classDecl);
            }
        };
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            file.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(ScenarioFile scenarioFile, Scope par) {
        ScenarioGroup group = scenarioFile.getGroup();
        final String className = scenarioFile.getName().replaceAll("\\W", "") + "Test";
        final ClassDecl classDecl = ClassDecl.of(group, className, className, new LinkedHashMap<String, AttributeDecl>(), new LinkedHashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        scenarioFile.setClassDecl(classDecl);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return className.equals(name) ? classDecl : super.resolve(name);
            }
        };
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            scenario.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(Scenario scenario, Scope par) {
        ClassDecl classDecl = scenario.getFile().getClassDecl();
        final String methodName = "scenario" + scenario.getName().replaceAll("\\W", "");
        SentenceList body = scenario.getBody();
        final MethodDecl methodDecl = MethodDecl.of(classDecl, methodName, null, "void", body);
        final ParameterDecl thisParam = ParameterDecl.of(methodDecl, "this", classDecl.getType());
        methodDecl.setParameters(Collections.singletonList(thisParam));
        classDecl.getMethods().add(methodDecl);
        scenario.setMethodDecl(methodDecl);
        body.accept(this, new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                if ("this".equals(name)) {
                    return thisParam;
                }
                if (methodName.equals(name)) {
                    return methodDecl;
                }
                return super.resolve(name);
            }
        });
        return null;
    }

    @Override
    public Object visit(Sentence sentence, Scope par) {
        return null;
    }

    @Override
    public Object visit(SentenceList sentenceList, Scope par) {
        final HashMap decls = new HashMap();
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                Decl decl = (Decl)decls.get(name);
                return decl != null ? decl : super.resolve(name);
            }

            @Override
            public void add(Decl decl) {
                if (decl instanceof VarDecl) {
                    decls.put(decl.getName(), decl);
                    return;
                }
                super.add(decl);
            }
        };
        for (Sentence item : sentenceList.getItems()) {
            item.accept(SymbolCollector.INSTANCE, decls);
            item.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(ThereSentence thereSentence, Scope par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visit(ExpectSentence expectSentence, Scope par) {
        expectSentence.getPredicates().replaceAll(it -> (ConditionalExpr)it.accept(this, par));
        return null;
    }

    @Override
    public Object visit(DiagramSentence diagramSentence, Scope par) {
        diagramSentence.setObject(diagramSentence.getObject().accept(this, par));
        return null;
    }

    @Override
    public Object visit(HasSentence hasSentence, Scope par) {
        hasSentence.setObject(hasSentence.getObject().accept(this, par));
        ClassDecl objectClass = NameResolver.resolveClass(par, hasSentence.getObject());
        String name = hasSentence.getObject().accept(Namer.INSTANCE, null);
        Scope scope = name != null ? new HidingScope(name, par) : par;
        for (NamedExpr namedExpr : hasSentence.getClauses()) {
            namedExpr.setExpr(namedExpr.getExpr().accept(this, scope));
            namedExpr.setName(NameResolver.resolveAttributeOrAssociation(objectClass, namedExpr.getName(), namedExpr.getExpr()));
        }
        return null;
    }

    @Override
    public Object visit(IsSentence isSentence, Scope par) {
        VarDecl varDecl = isSentence.getDescriptor();
        varDecl.setExpr(varDecl.getExpr().accept(this, par));
        if (varDecl.getType() == null) {
            varDecl.setType(varDecl.getExpr().accept(Typer.INSTANCE, null));
        }
        return null;
    }

    @Override
    public Object visit(CreateSentence createSentence, Scope par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visit(CallSentence callSentence, Scope par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visit(AnswerSentence answerSentence, Scope par) {
        if (answerSentence.getActor() != null) {
            answerSentence.setActor(answerSentence.getActor().accept(this, par));
        }
        answerSentence.setResult(answerSentence.getResult().accept(this, par));
        return null;
    }

    @Override
    public Object visit(ExprSentence exprSentence, Scope par) {
        exprSentence.setExpr(exprSentence.getExpr().accept(this, par));
        return null;
    }

    @Override
    public Expr visit(Expr expr, Scope par) {
        return expr;
    }

    @Override
    public Expr visit(AttributeAccess attributeAccess, Scope par) {
        attributeAccess.setReceiver(attributeAccess.getReceiver().accept(this, par));
        attributeAccess.setName(NameResolver.getAttributeOrAssociation(par, attributeAccess.getReceiver(), attributeAccess.getName()));
        return attributeAccess;
    }

    @Override
    public Expr visit(ExampleAccess exampleAccess, Scope par) {
        exampleAccess.setExpr(exampleAccess.getExpr().accept(this, par));
        return exampleAccess;
    }

    @Override
    public Expr visit(PrimaryExpr primaryExpr, Scope par) {
        return primaryExpr;
    }

    @Override
    public Expr visit(NameAccess nameAccess, Scope par) {
        if (nameAccess.getName() instanceof UnresolvedName) {
            UnresolvedName unresolvedName = (UnresolvedName)nameAccess.getName();
            String unresolvedValue = unresolvedName.getValue();
            Decl target = par.resolve(unresolvedValue);
            if (target == null) {
                return StringLiteral.of(unresolvedName.getText());
            }
            nameAccess.setName(ResolvedName.of(target));
        }
        return nameAccess;
    }

    @Override
    public Expr visit(NumberLiteral numberLiteral, Scope par) {
        return numberLiteral;
    }

    @Override
    public Expr visit(StringLiteral stringLiteral, Scope par) {
        return stringLiteral;
    }

    @Override
    public Expr visit(CreationExpr creationExpr, Scope par) {
        String className = StrUtil.cap(creationExpr.getClassName().accept(Namer.INSTANCE, par));
        ClassDecl classDecl = NameResolver.resolveClass(par, className);
        creationExpr.setClassName(ResolvedName.of(classDecl));
        for (NamedExpr namedExpr : creationExpr.getAttributes()) {
            namedExpr.setExpr(namedExpr.getExpr().accept(this, par));
            namedExpr.setName(NameResolver.resolveAttributeOrAssociation(classDecl, namedExpr.getName(), namedExpr.getExpr()));
        }
        return creationExpr;
    }

    @Override
    public Expr visit(CallExpr callExpr, Scope par) {
        List<NamedExpr> arguments = callExpr.getArguments();
        Expr receiver = callExpr.getReceiver();
        if (receiver != null) {
            callExpr.setReceiver(receiver.accept(this, par));
        } else {
            Decl thisDecl = par.resolve("this");
            NameAccess getThis = NameAccess.of(ResolvedName.of(thisDecl));
            callExpr.setReceiver(getThis);
        }
        for (NamedExpr argument : arguments) {
            argument.setExpr(argument.getExpr().accept(this, par));
        }
        ClassDecl receiverClass = NameResolver.resolveClass(par, callExpr.getReceiver());
        String methodName = callExpr.getName().accept(Namer.INSTANCE, null);
        MethodDecl method = NameResolver.resolveMethod(receiverClass, methodName);
        List<ParameterDecl> parameters = method.getParameters();
        boolean isNew = method.getType() == null;
        final HashMap<String, ParameterDecl> decls = new HashMap<String, ParameterDecl>();
        if (isNew) {
            ParameterDecl thisParam = ParameterDecl.of(method, "this", receiverClass.getType());
            parameters.add(thisParam);
            decls.put("this", thisParam);
        } else {
            decls.put("this", parameters.get(0));
            String params = parameters.stream().skip(1L).map(ParameterDecl::getName).collect(Collectors.joining(" "));
            String args = arguments.stream().map(NamedExpr::getName).map(n -> n.accept(Namer.INSTANCE, null)).collect(Collectors.joining(" "));
            if (!params.equals(args)) {
                throw new IllegalStateException("mismatching parameters and arguments:\nparameters: " + params + "\narguments : " + args);
            }
        }
        for (int i = 0; i < arguments.size(); ++i) {
            ParameterDecl param;
            NamedExpr argument = arguments.get(i);
            String name = argument.getName().accept(Namer.INSTANCE, null);
            Expr expr = argument.getExpr();
            if (isNew) {
                String type = expr.accept(Typer.INSTANCE, null);
                param = ParameterDecl.of(method, name, type);
                parameters.add(param);
            } else {
                param = parameters.get(i + 1);
            }
            argument.setName(ResolvedName.of(param));
            decls.put(name, param);
            String exprName = expr.accept(Namer.INSTANCE, null);
            if (exprName == null) continue;
            decls.put(exprName, param);
        }
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                Decl decl = (Decl)decls.get(name);
                return decl != null ? decl : super.resolve(name);
            }
        };
        callExpr.getBody().accept(this, scope);
        if (isNew) {
            String returnType = callExpr.accept(Typer.INSTANCE, null);
            method.setType(returnType);
        }
        method.getBody().getItems().addAll(callExpr.getBody().getItems());
        return callExpr;
    }

    @Override
    public Expr visit(ConditionalExpr conditionalExpr, Scope par) {
        return conditionalExpr;
    }

    @Override
    public Expr visit(AttributeCheckExpr attributeCheckExpr, Scope par) {
        attributeCheckExpr.setReceiver(attributeCheckExpr.getReceiver().accept(this, par));
        attributeCheckExpr.setValue(attributeCheckExpr.getValue().accept(this, par));
        attributeCheckExpr.setAttribute(NameResolver.getAttributeOrAssociation(par, attributeCheckExpr.getReceiver(), attributeCheckExpr.getAttribute()));
        return attributeCheckExpr;
    }

    @Override
    public Expr visit(CollectionExpr collectionExpr, Scope par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expr visit(ListExpr listExpr, Scope par) {
        listExpr.getElements().replaceAll(it -> it.accept(this, par));
        return listExpr;
    }

    @Override
    public Name visit(Name name, Scope par) {
        return name;
    }

    @Override
    public Name visit(ResolvedName resolvedName, Scope par) {
        return resolvedName;
    }

    @Override
    public Name visit(UnresolvedName unresolvedName, Scope par) {
        Decl decl = par.resolve(unresolvedName.getValue());
        return decl == null ? unresolvedName : ResolvedName.of(decl);
    }

    static ClassDecl resolveClass(Scope scope, Expr expr) {
        return NameResolver.resolveClass(scope, expr.accept(Typer.INSTANCE, null));
    }

    static ClassDecl resolveClass(Scope scope, String name) {
        ClassDecl resolve = (ClassDecl)scope.resolve(name);
        if (resolve != null) {
            return resolve;
        }
        ClassDecl decl = ClassDecl.of(null, name, name, new LinkedHashMap<String, AttributeDecl>(), new LinkedHashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        scope.add(decl);
        return decl;
    }

    static MethodDecl resolveMethod(ClassDecl classDecl, String name) {
        MethodDecl decl2;
        for (MethodDecl decl2 : classDecl.getMethods()) {
            if (!name.equals(decl2.getName())) continue;
            return decl2;
        }
        SentenceList body = SentenceList.of(new ArrayList<Sentence>());
        decl2 = MethodDecl.of(classDecl, name, new ArrayList<ParameterDecl>(), null, body);
        classDecl.getMethods().add(decl2);
        return decl2;
    }

    static Name resolveAttributeOrAssociation(ClassDecl classDecl, Name name, Expr rhs) {
        if (name.accept(ExtractDecl.INSTANCE, null) != null) {
            return name;
        }
        return ResolvedName.of(NameResolver.resolveAttributeOrAssociation(classDecl, name.accept(Namer.INSTANCE, null), rhs));
    }

    static Decl resolveAttributeOrAssociation(ClassDecl classDecl, String attributeName, Expr rhs) {
        AttributeDecl existingAttribute = classDecl.getAttributes().get(attributeName);
        if (existingAttribute != null) {
            return existingAttribute;
        }
        AssociationDecl existingAssociation = classDecl.getAssociations().get(attributeName);
        if (existingAssociation != null) {
            return existingAssociation;
        }
        String attributeType = rhs.accept(Typer.INSTANCE, null);
        if (attributeType.startsWith("List<")) {
            String otherType = attributeType.substring(5, attributeType.length() - 1);
            ClassDecl otherClass = classDecl.getGroup().getClasses().get(otherType);
            if (otherClass == null) {
                return NameResolver.resolveAttribute(classDecl, attributeName, attributeType);
            }
            return NameResolver.resolveAssociation(classDecl, attributeName, otherClass, 2);
        }
        ClassDecl otherClass = classDecl.getGroup().getClasses().get(attributeType);
        if (otherClass != null) {
            return NameResolver.resolveAssociation(classDecl, attributeName, otherClass, 1);
        }
        return NameResolver.resolveAttribute(classDecl, attributeName, attributeType);
    }

    static AttributeDecl resolveAttribute(ClassDecl classDecl, String name, String type) {
        AttributeDecl existing = classDecl.getAttributes().get(name);
        if (existing != null) {
            String existingType = existing.getType();
            if (!type.equals(existingType)) {
                throw new IllegalStateException("mismatched attribute type " + classDecl.getName() + "." + name + ": " + existingType + " vs " + type);
            }
            return existing;
        }
        AttributeDecl attribute = AttributeDecl.of(classDecl, name, type);
        classDecl.getAttributes().put(name, attribute);
        return attribute;
    }

    static AssociationDecl resolveAssociation(ClassDecl classDecl, String name, ClassDecl otherClass, int cardinality) {
        AssociationDecl existing = classDecl.getAssociations().get(name);
        if (existing != null) {
            if (existing.getTarget() != otherClass || existing.getCardinality() != cardinality) {
                throw new IllegalStateException("mismatched association type " + classDecl.getName() + "." + name + ": " + NameResolver.cardinalityString(existing.getCardinality()) + " " + existing.getTarget().getName() + " vs " + NameResolver.cardinalityString(cardinality) + " " + otherClass.getName());
            }
            return existing;
        }
        AssociationDecl association = AssociationDecl.of(classDecl, name, cardinality, otherClass, otherClass.getType(), null);
        AssociationDecl other = AssociationDecl.of(otherClass, classDecl.getName(), 1, classDecl, classDecl.getType(), null);
        association.setOther(other);
        other.setOther(association);
        classDecl.getAssociations().put(association.getName(), association);
        otherClass.getAssociations().put(other.getName(), other);
        return association;
    }

    private static String cardinalityString(int cardinality) {
        return cardinality == 1 ? "one" : "many";
    }

    static Name getAttributeOrAssociation(Scope scope, Expr receiver, Name name) {
        if (name.accept(ExtractDecl.INSTANCE, null) != null) {
            return name;
        }
        return NameResolver.getAttributeOrAssociation(NameResolver.resolveClass(scope, receiver), name.accept(Namer.INSTANCE, null));
    }

    static Name getAttributeOrAssociation(ClassDecl receiverClass, String name) {
        AttributeDecl attribute = receiverClass.getAttributes().get(name);
        if (attribute != null) {
            return ResolvedName.of(attribute);
        }
        AssociationDecl association = receiverClass.getAssociations().get(name);
        if (association != null) {
            return ResolvedName.of(association);
        }
        throw new IllegalStateException("unresolved attribute " + receiverClass.getName() + "." + name);
    }
}

