package org.fulib.scenarios.ast.decl;

import java.util.List;
import java.util.Map;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.ScenarioGroup;


public interface ClassDecl extends Decl
{
	// =============== Static Methods ===============
	static ClassDecl of(ScenarioGroup group, String name, String type, Map<String, AttributeDecl> attributes, Map<String, AssociationDecl> associations, List<MethodDecl> methods) { return new Impl(group, name, type, attributes, associations, methods); }
	// =============== Properties ===============
	ScenarioGroup getGroup();
	void setGroup(ScenarioGroup group);
	String getName();
	void setName(String name);
	String getType();
	void setType(String type);
	Map<String, AttributeDecl> getAttributes();
	void setAttributes(Map<String, AttributeDecl> attributes);
	Map<String, AssociationDecl> getAssociations();
	void setAssociations(Map<String, AssociationDecl> associations);
	List<MethodDecl> getMethods();
	void setMethods(List<MethodDecl> methods);

	// =============== Methods ===============
	<P, R> R accept(ClassDecl.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements ClassDecl
	{
		// =============== Fields ===============
		private ScenarioGroup group;
		private String name;
		private String type;
		private Map<String, AttributeDecl> attributes;
		private Map<String, AssociationDecl> associations;
		private List<MethodDecl> methods;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(ScenarioGroup group, String name, String type, Map<String, AttributeDecl> attributes, Map<String, AssociationDecl> associations, List<MethodDecl> methods)
		{
			this.group = group;
			this.name = name;
			this.type = type;
			this.attributes = attributes;
			this.associations = associations;
			this.methods = methods;
		}

		// =============== Properties ===============
		@Override public ScenarioGroup getGroup() { return this.group; }
		@Override public void setGroup(ScenarioGroup group) { this.group = group; }
		@Override public String getName() { return this.name; }
		@Override public void setName(String name) { this.name = name; }
		@Override public String getType() { return this.type; }
		@Override public void setType(String type) { this.type = type; }
		@Override public Map<String, AttributeDecl> getAttributes() { return this.attributes; }
		@Override public void setAttributes(Map<String, AttributeDecl> attributes) { this.attributes = attributes; }
		@Override public Map<String, AssociationDecl> getAssociations() { return this.associations; }
		@Override public void setAssociations(Map<String, AssociationDecl> associations) { this.associations = associations; }
		@Override public List<MethodDecl> getMethods() { return this.methods; }
		@Override public void setMethods(List<MethodDecl> methods) { this.methods = methods; }

		// =============== Methods ===============
		@Override public <P, R> R accept(ClassDecl.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Decl.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(ClassDecl classDecl, P par);
	}
}
