package org.fulib.scenarios.ast.expr.call;

import java.util.List;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.sentence.SentenceList;


public interface CallExpr extends Expr
{
	// =============== Static Methods ===============
	static CallExpr of(Name name, Expr receiver, List<NamedExpr> arguments, SentenceList body) { return new Impl(name, receiver, arguments, body); }
	// =============== Properties ===============
	Name getName();
	void setName(Name name);
	Expr getReceiver();
	void setReceiver(Expr receiver);
	List<NamedExpr> getArguments();
	void setArguments(List<NamedExpr> arguments);
	SentenceList getBody();
	void setBody(SentenceList body);

	// =============== Methods ===============
	<P, R> R accept(CallExpr.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements CallExpr
	{
		// =============== Fields ===============
		private Name name;
		private Expr receiver;
		private List<NamedExpr> arguments;
		private SentenceList body;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(Name name, Expr receiver, List<NamedExpr> arguments, SentenceList body)
		{
			this.name = name;
			this.receiver = receiver;
			this.arguments = arguments;
			this.body = body;
		}

		// =============== Properties ===============
		@Override public Name getName() { return this.name; }
		@Override public void setName(Name name) { this.name = name; }
		@Override public Expr getReceiver() { return this.receiver; }
		@Override public void setReceiver(Expr receiver) { this.receiver = receiver; }
		@Override public List<NamedExpr> getArguments() { return this.arguments; }
		@Override public void setArguments(List<NamedExpr> arguments) { this.arguments = arguments; }
		@Override public SentenceList getBody() { return this.body; }
		@Override public void setBody(SentenceList body) { this.body = body; }

		// =============== Methods ===============
		@Override public <P, R> R accept(CallExpr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Expr.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(CallExpr callExpr, P par);
	}
}
