package org.fulib.scenarios.ast.sentence;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.expr.Expr;


public interface AnswerSentence extends Sentence
{
	// =============== Static Methods ===============
	static AnswerSentence of(Name actor, Expr result) { return new Impl(actor, result); }
	// =============== Properties ===============
	Name getActor();
	void setActor(Name actor);
	Expr getResult();
	void setResult(Expr result);

	// =============== Methods ===============
	<P, R> R accept(AnswerSentence.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements AnswerSentence
	{
		// =============== Fields ===============
		private Name actor;
		private Expr result;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(Name actor, Expr result)
		{
			this.actor = actor;
			this.result = result;
		}

		// =============== Properties ===============
		@Override public Name getActor() { return this.actor; }
		@Override public void setActor(Name actor) { this.actor = actor; }
		@Override public Expr getResult() { return this.result; }
		@Override public void setResult(Expr result) { this.result = result; }

		// =============== Methods ===============
		@Override public <P, R> R accept(AnswerSentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Sentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(AnswerSentence answerSentence, P par);
	}
}
