package org.fulib.scenarios.ast.sentence;

import java.util.List;
import org.fulib.scenarios.ast.Node;


public interface SentenceList extends Sentence
{
	// =============== Static Methods ===============
	static SentenceList of(List<Sentence> items) { return new Impl(items); }
	// =============== Properties ===============
	List<Sentence> getItems();
	void setItems(List<Sentence> items);

	// =============== Methods ===============
	<P, R> R accept(SentenceList.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements SentenceList
	{
		// =============== Fields ===============
		private List<Sentence> items;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(List<Sentence> items)
		{
			this.items = items;
		}

		// =============== Properties ===============
		@Override public List<Sentence> getItems() { return this.items; }
		@Override public void setItems(List<Sentence> items) { this.items = items; }

		// =============== Methods ===============
		@Override public <P, R> R accept(SentenceList.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Sentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(SentenceList sentenceList, P par);
	}
}
