/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.builder;

import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Objects;
import org.fulib.classmodel.AssocRole;

public class AssociationBuilder {
    private AssocRole srcRole;

    public AssociationBuilder(AssocRole myRole) {
        this.srcRole = myRole;
    }

    public AssociationBuilder setAggregation() {
        this.srcRole.setAggregation(true);
        return this;
    }

    public AssociationBuilder setSourceRoleCollection(Class collectionClass) {
        Objects.requireNonNull(collectionClass);
        if (Collection.class.isAssignableFrom(collectionClass)) {
            String roleType = this.deriveRoleType(collectionClass);
            this.srcRole.setRoleType(roleType);
        }
        return this;
    }

    public AssociationBuilder setTargetRoleCollection(Class collectionClass) {
        Objects.requireNonNull(collectionClass);
        if (Collection.class.isAssignableFrom(collectionClass)) {
            String roleType = this.deriveRoleType(collectionClass);
            this.srcRole.getOther().setRoleType(roleType);
        }
        return this;
    }

    public AssociationBuilder setJavaFXPropertyStyle() {
        this.srcRole.setPropertyStyle("JavaFX");
        this.srcRole.getOther().setPropertyStyle("JavaFX");
        return this;
    }

    private String deriveRoleType(Class collectionClass1) {
        Class collectionClass = collectionClass1;
        if (!Collection.class.isAssignableFrom(collectionClass)) {
            throw new IllegalArgumentException("class is no collection");
        }
        String roleType = collectionClass.getName();
        TypeVariable<Class<T>>[] typeParameters = collectionClass.getTypeParameters();
        if (typeParameters.length == 1) {
            roleType = roleType + "<%s>";
        }
        return roleType;
    }
}

