/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.classmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fulib.StrUtil;
import org.fulib.classmodel.CodeFragment;

public class FileFragmentMap {
    protected PropertyChangeSupport listeners = null;
    private LinkedHashMap<String, CodeFragment> codeMap = new LinkedHashMap();
    private ArrayList<CodeFragment> fragmentList = new ArrayList();
    public static final String PROPERTY_fileName = "fileName";
    private String fileName;

    public boolean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listeners != null) {
            this.listeners.firePropertyChange(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    public boolean addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(listener);
        return true;
    }

    public boolean addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyName, listener);
        return true;
    }

    public boolean removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(listener);
        }
        return true;
    }

    public boolean removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(propertyName, listener);
        }
        return true;
    }

    public FileFragmentMap() {
        CodeFragment startFragment = new CodeFragment().setKey("start:").setText("");
        this.fragmentList.add(startFragment);
    }

    public FileFragmentMap(String fileName) {
        this.setFileName(fileName);
    }

    public CodeFragment getFragment(String key) {
        return this.codeMap.get(key);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getFileName());
        result.append("\n");
        result.append(this.getFileText());
        return result.substring(1);
    }

    private String getFileText() {
        StringBuilder fileBody = new StringBuilder();
        for (CodeFragment fragment : this.fragmentList) {
            fileBody.append(fragment.getText());
        }
        return fileBody.toString();
    }

    public CodeFragment add(String key, String newText, int newLines) {
        return this.add(key, newText, newLines, false);
    }

    public CodeFragment add(String key, String newText, int newLines, boolean removeFragment) {
        CodeFragment result = this.codeMap.get(key);
        if (result != null) {
            if (result.getText().indexOf("// no") >= 0) {
                return result;
            }
            if (removeFragment) {
                this.codeMap.remove(key);
                int pos = this.fragmentList.indexOf(result);
                this.fragmentList.remove(pos);
                CodeFragment gap = this.fragmentList.get(pos - 1);
                if (StrUtil.stringEquals(gap.getKey(), "gap:")) {
                    this.fragmentList.remove(pos - 1);
                }
                return result;
            }
            if (newText.indexOf("@") < 0) {
                if (key.equals("class")) {
                    Pattern pattern = Pattern.compile("class\\s+(\\w+)\\s*(extends\\s+[^\\s]+)?");
                    Matcher match = pattern.matcher(newText);
                    boolean b = match.find();
                    String className = match.group(1);
                    String extendsClause = match.group(2);
                    extendsClause = extendsClause == null ? "" : extendsClause + " ";
                    int resultClassNamePos = result.getText().indexOf("class " + className);
                    if (resultClassNamePos >= 0) {
                        String prefix = result.getText().substring(0, resultClassNamePos);
                        String middle = "class " + className + " " + extendsClause;
                        String suffix = " \n{";
                        int implementsPos = result.getText().indexOf("implements");
                        if (implementsPos >= 0) {
                            suffix = " " + result.getText().substring(implementsPos);
                        }
                        newText = prefix + middle + suffix;
                    }
                } else if (key.startsWith("attribute")) {
                    int newTextPublicPos = newText.indexOf("public");
                    int resultPublicPos = result.getText().indexOf("public");
                    if (newTextPublicPos >= 0 && resultPublicPos >= 0) {
                        newText = result.getText().substring(0, resultPublicPos) + newText.substring(newTextPublicPos);
                    }
                } else if (key.startsWith("attribute")) {
                    int newTextPrivatePos = newText.indexOf("private");
                    int resultPrivatePos = result.getText().indexOf("private");
                    if (newTextPrivatePos >= 0 && resultPrivatePos >= 0) {
                        newText = result.getText().substring(0, resultPrivatePos) + newText.substring(newTextPrivatePos);
                    }
                }
            }
            result.setText(newText.trim());
            return result;
        }
        if (removeFragment) {
            return result;
        }
        result = new CodeFragment().setKey(key).setText(newText);
        this.codeMap.put(key, result);
        CodeFragment gap = this.getNewLineGapFragment(newLines);
        if (key.startsWith("attribute") || key.startsWith("method") || key.startsWith("constructor")) {
            this.add(result, "classEnd");
            this.add(gap, "classEnd");
            return result;
        }
        if (key.startsWith("import")) {
            CodeFragment oldFragment = this.codeMap.get("class");
            int pos = this.fragmentList.indexOf(oldFragment);
            --pos;
            pos = Math.max(0, pos);
            this.fragmentList.add(pos, gap);
            this.fragmentList.add(++pos, gap);
            this.fragmentList.add(++pos, result);
            return result;
        }
        this.add(result);
        this.add(gap, "classEnd");
        return result;
    }

    private CodeFragment getNewLineGapFragment(int newLines) {
        CodeFragment gap = new CodeFragment().setKey("gap:");
        String text = "";
        for (int i = 0; i < newLines; ++i) {
            text = text + "\n";
        }
        gap.setText(text);
        return gap;
    }

    private void add(CodeFragment result, String posKey) {
        CodeFragment oldFragment = this.codeMap.get(posKey);
        int pos = this.fragmentList.indexOf(oldFragment);
        if (pos == -1) {
            this.fragmentList.add(result);
        } else {
            this.fragmentList.add(pos, result);
        }
        this.codeMap.put(result.getKey(), result);
    }

    public void add(CodeFragment fragment) {
        this.fragmentList.add(fragment);
        this.codeMap.put(fragment.getKey(), fragment);
    }

    public void writeFile() {
        try {
            Path path = Paths.get(this.fileName, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, this.getFileText().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean classBodyIsEmpty(FileFragmentMap fragmentMap) {
        CodeFragment startFragment = this.codeMap.get("class");
        CodeFragment endFragment = this.codeMap.get("classEnd");
        if (startFragment == null || endFragment == null) {
            return true;
        }
        int endPos = this.fragmentList.indexOf(endFragment);
        for (int i = this.fragmentList.indexOf(startFragment) + 1; i < endPos; ++i) {
            CodeFragment fragment = this.fragmentList.get(i);
            if (StrUtil.stringEquals(fragment.getKey(), "gap:")) continue;
            return false;
        }
        return true;
    }

    public void removeYou() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileFragmentMap setFileName(String value) {
        if (value == null ? this.fileName != null : !value.equals(this.fileName)) {
            String oldValue = this.fileName;
            this.fileName = value;
            this.firePropertyChange(PROPERTY_fileName, oldValue, value);
        }
        return this;
    }
}

