/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Logger;
import org.fulib.scenarios.tool.Tools;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import spark.Request;
import spark.Response;
import spark.Spark;

public class WebService {
    private static final String TEMP_DIR_PREFIX = "fulibScenarios";
    private static final String PACKAGE_NAME = "webapp";
    private static final String SCENARIO_FILE_NAME = "scenario.md";

    public static void main(String[] args) {
        Spark.port((int)4567);
        Spark.staticFiles.externalLocation(PACKAGE_NAME);
        Spark.get((String)"/github", (req, res) -> {
            res.redirect("https://github.com/fujaba/fulib");
            return res;
        });
        Spark.post((String)"/runcodegen", WebService::runCodeGen);
        Logger.getGlobal().info("scenario server started ... ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runCodeGen(Request req, Response res) throws Exception {
        Path codegendir = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]);
        Path srcDir = codegendir.resolve("src");
        Path mainPackageDir = srcDir.resolve(PACKAGE_NAME);
        Path modelSrcDir = codegendir.resolve("model_src");
        Path testSrcDir = codegendir.resolve("test_src");
        Path scenarioFile = mainPackageDir.resolve(SCENARIO_FILE_NAME);
        Path modelClassesDir = codegendir.resolve("model_classes");
        Path testClassesDir = codegendir.resolve("test_classes");
        try {
            String body = req.body();
            JSONObject jsonObject = new JSONObject(body);
            String bodyText = jsonObject.getString("scenarioText");
            Files.createDirectories(srcDir, new FileAttribute[0]);
            Files.createDirectories(mainPackageDir, new FileAttribute[0]);
            Files.write(scenarioFile, bodyText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Files.createDirectories(modelSrcDir, new FileAttribute[0]);
            Files.createDirectories(testSrcDir, new FileAttribute[0]);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int exitCode = Tools.genCompileRun(out, out, srcDir, modelSrcDir, testSrcDir, modelClassesDir, testClassesDir, "--class-diagram-svg", "--object-diagram-svg");
            JSONObject result = new JSONObject();
            result.put("exitCode", exitCode);
            String output = new String(out.toByteArray(), StandardCharsets.UTF_8);
            result.put("output", (Object)output.replace(codegendir.toString(), "."));
            if (exitCode < 0) {
                Logger.getGlobal().severe(output);
            }
            if (exitCode == 0 || (exitCode & 4) != 0) {
                JSONArray methodArray = new JSONArray();
                Files.walk(testSrcDir, new FileVisitOption[0]).filter(Tools::isJava).forEach(file -> WebService.readTestMethod(methodArray, file));
                result.put("testMethods", (Object)methodArray);
                Path classDiagramFile = modelSrcDir.resolve(PACKAGE_NAME).resolve("classDiagram.svg");
                if (Files.exists(classDiagramFile, new LinkOption[0])) {
                    byte[] bytes = Files.readAllBytes(classDiagramFile);
                    String svgText = new String(bytes, StandardCharsets.UTF_8);
                    result.put("classDiagram", (Object)svgText);
                }
                StringBuilder objectDiagramSvgText = new StringBuilder();
                Path srcPackage = srcDir.resolve(PACKAGE_NAME);
                Files.walk(srcPackage, new FileVisitOption[0]).filter(file -> file.toString().endsWith(".svg") || file.toString().endsWith(".yaml")).forEach(file -> {
                    try {
                        byte[] objectDiagramBytes = Files.readAllBytes(file);
                        String openTag = "<p>";
                        String closeTag = "</p>";
                        if (file.toString().endsWith(".yaml")) {
                            openTag = "<pre>\n";
                            closeTag = "</pre>";
                        }
                        String text = String.format("<h4>%s</h4>\n%s%s%s\n", file.getFileName(), openTag, new String(objectDiagramBytes), closeTag);
                        objectDiagramSvgText.append(text);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                result.put("objectDiagram", (Object)objectDiagramSvgText.toString());
            }
            res.type("application/json");
            String string = result.toString(3);
            return string;
        }
        finally {
            Tools.deleteRecursively(codegendir);
        }
    }

    private static void readTestMethod(JSONArray methodArray, Path file) {
        try {
            WebService.tryReadTestMethod(methodArray, file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void tryReadTestMethod(JSONArray methodArray, Path file) throws IOException, JSONException {
        List<String> lines = Files.readAllLines(file);
        String methodName = null;
        StringBuilder methodBody = null;
        for (String line : lines) {
            int end;
            if (line.startsWith("   public ") && (end = line.indexOf(41)) >= 0) {
                methodName = line.substring("   public ".length(), end + 1);
                methodBody = new StringBuilder();
                continue;
            }
            if (methodName != null && "   }".equals(line)) {
                JSONObject method = new JSONObject();
                method.put("name", (Object)methodName);
                method.put("body", (Object)methodBody.toString());
                methodArray.put((Object)method);
                methodName = null;
                methodBody = null;
                continue;
            }
            if (methodName == null || !line.startsWith("      ")) continue;
            methodBody.append(line, 6, line.length()).append("\n");
        }
    }
}

