/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.compiler;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.fulib.StrUtil;
import org.fulib.builder.ClassModelManager;
import org.fulib.builder.ModelEventManager;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.FMethod;
import org.fulib.scenarios.parser.FulibScenariosBaseListener;
import org.fulib.scenarios.parser.FulibScenariosParser;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;

public class ScenarioTestCollector
extends FulibScenariosBaseListener {
    public static final String VERB_PHRASE = "verbPhrase";
    public static final String TO_OBJ_NAME = "toObjName";
    public static final String FROM_ATTR_NAME = "fromAttrName";
    public static final String FROM_CLASS_NAME = "fromClassName";
    public static final String TO_ATTR_NAME = "toAttrName";
    public static final String FROM_OBJ_NAME = "fromObjName";
    public static final String VALUE_CLASS_NAME = "valueClassName";
    public static final String VALUE_CLASS_IS_ATTR_TYPE = "valueClassIsAttrType";
    public static final String NEW_VAR_NAME = "newVarName";
    public static final String VALUE_NAME = "valueName";
    public static final String LOOP_INTRO = "loopIntro";
    public static final String FIRST_ON = "firstOn";
    public static final String ANOTHER_ON = "anotherOn";
    public static final String AS_PHRASE = "asPhrase";
    public static final String SECOND_FROM_ATTR_NAME = "secondFromAttrName";
    public static final String SECOND_FROM_ATTR_INDEX = "secondFromAttrIndex";
    public static final String FIRST_FROM_ATTR_INDEX = "firstFromAttrIndex";
    public static final String SIZE = "size";
    public static final String RANGE_END = "rangeEnd";
    public static final String RANGE_START = "rangeStart";
    public static final String ENTRY_CLASS_NAME = "entryClassName";
    public static final String SECOND_TO_OBJ_NAME = "secondToObjName";
    public static final String PREPARE_VALUE_LIST = "prepareValueList";
    public static final String PREPARE_TARGET_LIST = "prepareTargetList";
    public static final String VALUE_LIST_NAME = "valueListName";
    private final ClassModelManager mm;
    public StringBuilder methodBody = new StringBuilder();
    public StringBuilder settings;
    public StringBuilder references;
    private LinkedHashMap<String, String> object2ClassMap;
    private String docDir;
    private LinkedHashMap<String, TreeSet<String>> attrValueExamplesMap;
    private LinkedHashMap<String, ArrayList<String>> currentAttrValueMap;
    private LinkedHashMap<String, String> methodParams;
    private LinkedHashMap<String, String> methodLocalVars;
    private String objectName;
    private String className;
    private FMethod currentMethod;
    private final ModelEventManager em;
    private Clazz clazz;
    private final ClassModel classModel;
    private String attrName;
    private String attrValue;
    private ArrayList<String> valueDataTextList = new ArrayList();
    private ArrayList<String> valueDataNameList = new ArrayList();
    private ArrayList<String> previousValueDataTextList = new ArrayList();
    private ArrayList<String> previousValueDataNameList = new ArrayList();
    private Clazz currentRegisterClazz;
    private String attrType;
    private String sentenceType = null;
    private String lastInvocation;
    private int oldMethodBodyLength;
    private String loopIntro = null;
    private String indent = "";
    private String statementClosing = "";
    private ArrayList<String> toObjNameList;
    private ArrayList<String> toObjTextList;

    public ScenarioTestCollector(LinkedHashMap<String, String> object2ClassMap, String docDir) {
        this.object2ClassMap = object2ClassMap;
        this.docDir = docDir;
        this.attrValueExamplesMap = new LinkedHashMap();
        this.em = new ModelEventManager();
        this.mm = new ClassModelManager(this.em);
        this.em.setModelManager(this.mm);
        this.classModel = this.mm.getClassModel();
    }

    public void initMethodParams() {
        this.methodParams = new LinkedHashMap();
        this.methodLocalVars = new LinkedHashMap();
    }

    public LinkedHashMap<String, String> getMethodLocalVars() {
        return this.methodLocalVars;
    }

    public LinkedHashMap<String, String> getMethodParams() {
        return this.methodParams;
    }

    public LinkedHashMap<String, String> getObject2ClassMap() {
        return this.object2ClassMap;
    }

    public LinkedHashMap<String, TreeSet<String>> getAttrValueExamplesMap() {
        return this.attrValueExamplesMap;
    }

    public void setObject2ClassMap(LinkedHashMap<String, String> object2ClassMap) {
        this.object2ClassMap = object2ClassMap;
    }

    public ClassModelManager getModelManager() {
        return this.mm;
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    @Override
    public void enterScenario(FulibScenariosParser.ScenarioContext ctx) {
        this.references = new StringBuilder();
    }

    @Override
    public void exitScenario(FulibScenariosParser.ScenarioContext ctx) {
        this.methodBody.append(this.references.toString());
    }

    @Override
    public void enterDirectSentence(FulibScenariosParser.DirectSentenceContext ctx) {
        this.settings = new StringBuilder();
        this.objectName = StrUtil.downFirstChar(this.getMultiName(ctx.objectName));
        this.className = StrUtil.cap(ctx.className.getText());
        this.clazz = this.mm.haveClass(this.className);
    }

    @Override
    public void exitDirectSentence(FulibScenariosParser.DirectSentenceContext ctx) {
        this.objectName = this.getMultiName(ctx.objectName);
        this.objectName = StrUtil.downFirstChar(this.objectName);
        this.className = StrUtil.cap(ctx.className.getText());
        STGroupFile group = new STGroupFile("templates/junitTest.stg");
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        ST st = group.getInstanceOf("objectCreate");
        st.add("className", (Object)StrUtil.cap(this.className));
        st.add("objectName", (Object)this.objectName);
        st.add("settings", (Object)this.settings);
        String result = st.render();
        this.methodBody.append(result);
    }

    @Override
    public void enterThereSentence(FulibScenariosParser.ThereSentenceContext ctx) {
        this.settings = new StringBuilder();
        this.objectName = null;
        if (ctx.objectName != null) {
            this.objectName = StrUtil.downFirstChar(this.getMultiName(ctx.objectName));
        }
        this.className = ctx.className == null ? StrUtil.cap(this.objectName) : StrUtil.cap(ctx.className.getText());
        this.clazz = this.mm.haveClass(StrUtil.cap(this.className));
    }

    @Override
    public void enterHasSentence(FulibScenariosParser.HasSentenceContext ctx) {
        this.settings = new StringBuilder();
        this.objectName = StrUtil.downFirstChar(this.getMultiName(ctx.objectName));
    }

    @Override
    public void exitThereSentence(FulibScenariosParser.ThereSentenceContext ctx) {
        STGroupFile group = new STGroupFile("templates/junitTest.stg");
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        ST st = group.getInstanceOf("objectCreate");
        this.objectName = StrUtil.downFirstChar(this.objectName);
        this.className = ctx.className == null ? StrUtil.cap(this.objectName) : StrUtil.cap(ctx.className.getText());
        this.mm.haveClass(this.className);
        this.object2ClassMap.put(this.objectName, this.className);
        st.add("className", (Object)StrUtil.cap(this.className));
        st.add("objectName", (Object)this.objectName);
        st.add("settings", (Object)this.settings);
        String result = st.render();
        this.methodBody.append(result);
    }

    @Override
    public void exitNumberWithClause(FulibScenariosParser.NumberWithClauseContext ctx) {
        String attrName = ctx.attrName.getText();
        ArrayList<String> valueList = new ArrayList<String>();
        String value = ctx.value.getText();
        valueList.add(value);
        this.currentAttrValueMap.put(attrName, valueList);
    }

    @Override
    public void exitHasSentence(FulibScenariosParser.HasSentenceContext ctx) {
        this.className = this.object2ClassMap.get(this.objectName);
        if (!this.settings.toString().trim().equals("")) {
            String result = String.format("%s%s;\n\n", this.objectName, this.settings.toString().trim());
            this.methodBody.append(result);
        }
    }

    @Override
    public void enterDiagramSentence(FulibScenariosParser.DiagramSentenceContext ctx) {
        String fileName = StrUtil.downFirstChar(ctx.fileName.getText());
        String rootObj = StrUtil.downFirstChar(ctx.type.getText());
        String stmt = String.format("\nFulibTools.objectDiagrams().dumpPng(\"%s/%s\", %s);\n\n", this.docDir, fileName, rootObj);
        this.references.append(stmt);
    }

    @Override
    public void enterCallSentence(FulibScenariosParser.CallSentenceContext ctx) {
        this.methodBody.append((CharSequence)this.references);
        this.references.setLength(0);
        this.methodParams = new LinkedHashMap();
        this.methodLocalVars = new LinkedHashMap();
        this.objectName = StrUtil.downFirstChar(ctx.objectName.getText());
        this.methodParams.put("this", this.objectName);
        this.methodLocalVars.put("this", this.objectName);
        this.sentenceType = "callSentence";
    }

    @Override
    public void exitCallSentence(FulibScenariosParser.CallSentenceContext ctx) {
        this.references.setLength(0);
        this.sentenceType = null;
        String methodName = StrUtil.downFirstChar(ctx.methodName.getText());
        String actualParams = String.join((CharSequence)", ", this.methodParams.values());
        int pos = actualParams.indexOf(44);
        actualParams = pos < 0 ? "" : actualParams.substring(pos + 1).trim();
        this.lastInvocation = String.format("%s.%s(%s);\n", this.objectName, methodName, actualParams);
        this.methodBody.append(this.lastInvocation);
        String className = this.object2ClassMap.get(this.objectName);
        if (className != null) {
            Clazz clazz = this.getModelManager().haveClass(className);
            FMethod method = this.getModelManager().haveMethod(clazz, methodName);
            method.writeReturnType("void");
            for (Map.Entry<String, String> entry : this.methodParams.entrySet()) {
                String paramName = entry.getKey();
                String paramValue = entry.getValue();
                String paramType = this.object2ClassMap.get(paramValue);
                if (paramType == null) {
                    paramType = this.getAttrType(paramValue);
                }
                method.readParams().put(paramName, paramType);
            }
        }
    }

    @Override
    public void enterChainSentence(FulibScenariosParser.ChainSentenceContext ctx) {
        String methodName = StrUtil.downFirstChar(ctx.methodName.getText());
        this.currentMethod = this.getModelManager().getMethod(methodName);
        if (ctx.loopIntro != null) {
            if (ctx.loopIntro.children.get(0) instanceof FulibScenariosParser.LoopClauseContext) {
                this.loopIntro = LOOP_INTRO;
            } else if (ctx.loopIntro.children.get(0) instanceof FulibScenariosParser.OnPhraseContext && this.loopIntro.equals(LOOP_INTRO)) {
                this.loopIntro = FIRST_ON;
            } else if (ctx.loopIntro.children.get(0) instanceof FulibScenariosParser.OnPhraseContext && (this.loopIntro.equals(FIRST_ON) || this.loopIntro.equals(AS_PHRASE))) {
                this.loopIntro = ANOTHER_ON;
            } else if (ctx.loopIntro.children.get(0) instanceof FulibScenariosParser.AsPhraseContext) {
                this.loopIntro = AS_PHRASE;
            }
        } else {
            this.loopIntro = null;
        }
    }

    @Override
    public void exitChainSentence(FulibScenariosParser.ChainSentenceContext ctx) {
        String result = this.statementClosing;
        if (!this.statementClosing.equals("")) {
            this.indent = this.indent.substring(3);
        }
        this.statementClosing = "";
        this.appendToCurrentMethodBody(result);
    }

    @Override
    public void exitContinuePhrase(FulibScenariosParser.ContinuePhraseContext ctx) {
        String result = this.indent + "      continue;\n";
        result = result + this.indent + "   }\n";
        this.appendToCurrentMethodBody(result);
        this.indent = this.indent.substring(3);
        this.statementClosing = "";
    }

    @Override
    public void exitStopPhrase(FulibScenariosParser.StopPhraseContext ctx) {
        String result = "" + this.indent + "      break;\n" + this.indent + "   }\n" + this.indent + "}\n";
        this.appendToCurrentMethodBody(result);
        this.indent = "";
        this.statementClosing = "";
    }

    @Override
    public void enterCreatePhrase(FulibScenariosParser.CreatePhraseContext ctx) {
        this.sentenceType = VERB_PHRASE;
        this.currentAttrValueMap = new LinkedHashMap();
    }

    @Override
    public void exitCreatePhrase(FulibScenariosParser.CreatePhraseContext ctx) {
        String newObjectName;
        this.sentenceType = null;
        String className = StrUtil.cap(ctx.className.getText());
        String resultListName = StrUtil.downFirstChar(className) + "List";
        Clazz newClazz = this.getModelManager().haveClass(className);
        String objectId = this.attrValue;
        STGroupFile group = new STGroupFile("templates/junitTest.stg");
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        String attrName = this.currentAttrValueMap.keySet().iterator().next();
        String value = this.currentAttrValueMap.get(attrName).get(0);
        String objectToClassMapName = newObjectName = StrUtil.downFirstChar(value);
        boolean thereAreLists = false;
        String firstAttrName = null;
        String indent = "";
        ArrayList<String> firstValueList = null;
        for (String attr : this.currentAttrValueMap.keySet()) {
            ArrayList<String> valueList = this.currentAttrValueMap.get(attr);
            if (this.isList(valueList)) {
                String attrType = StrUtil.cap(this.getAttrType(valueList.get(0)));
                if (attrType.equals(StrUtil.cap("double"))) {
                    attrType = "Integer";
                }
                String listInit = String.format("      java.util.ArrayList<%s> %sList = new java.util.ArrayList<%s>();\n", attrType, attr, attrType);
                for (String v : valueList) {
                    if (v.indexOf(58) < 0) {
                        String actualParam = String.format("\"%s\"", v);
                        if (!attrType.equals("String")) {
                            actualParam = v;
                        }
                        String oneAdd = String.format("      %sList.add(%s);\n", attr, actualParam);
                        listInit = listInit + oneAdd;
                        continue;
                    }
                    String[] split = v.split("\\:");
                    String startIndex = this.indexPart(split[0]);
                    String endIndex = this.indexPart(split[1]);
                    String baseName = ScenarioTestCollector.truncate(split[0], startIndex.length());
                    if (baseName.length() > 0) {
                        if (firstAttrName == null) {
                            resultListName = baseName + "List";
                        }
                        baseName = "\"" + baseName + "\"+";
                    }
                    String manyAdd = String.format("      for (int i = %s; i <= %s; i++) {\n         %sList.add(%si);\n      }\n", startIndex, endIndex, attr, baseName);
                    listInit = listInit + manyAdd;
                }
                listInit = listInit + "\n";
                this.appendToCurrentMethodBody(listInit);
                thereAreLists = true;
            }
            if (firstAttrName != null) continue;
            firstAttrName = attr;
            firstValueList = valueList;
        }
        if (thereAreLists) {
            String objList = String.format("      java.util.ArrayList<%s> %s = new java.util.ArrayList<>();\n", className, resultListName);
            this.appendToCurrentMethodBody(objList);
            String forStmt = String.format("      for (int i = 0; i < %sList.size(); i++ ) {\n", firstAttrName);
            this.appendToCurrentMethodBody(forStmt);
            newObjectName = StrUtil.downFirstChar(className) + "Tmp";
            indent = "   ";
        }
        ST st = group.getInstanceOf("objectCreate");
        st.add("className", (Object)className);
        st.add("objectName", (Object)newObjectName);
        String result = indent + "      " + st.render();
        for (String attr : this.currentAttrValueMap.keySet()) {
            ArrayList<String> valueList = this.currentAttrValueMap.get(attr);
            String oneValue = valueList.get(0);
            String attrType = this.getAttrType(oneValue);
            if (this.isList(valueList)) {
                oneValue = String.format("%sList.get(i)", attr);
            }
            String text = this.computeFullSetterCall(className, newClazz, newObjectName, attr, attrType, oneValue);
            result = result + indent + text;
        }
        if (thereAreLists) {
            String stmt = String.format("         %s.add(%sTmp);\n      }\n\n", resultListName, StrUtil.downFirstChar(className));
            result = result + stmt;
        }
        if (objectToClassMapName.indexOf(58) >= 0) {
            objectToClassMapName = objectToClassMapName.split("\\:")[0];
            String index = this.indexPart(objectToClassMapName);
            objectToClassMapName = ScenarioTestCollector.truncate(objectToClassMapName, index.length()) + "_i";
        }
        this.object2ClassMap.put(objectToClassMapName, className);
        this.appendToCurrentMethodBody(result);
    }

    private void appendToCurrentMethodBody(String result) {
        String currentMethodBody = this.currentMethod.getMethodBody();
        currentMethodBody = currentMethodBody == null ? "" : currentMethodBody;
        currentMethodBody = currentMethodBody + result;
        this.currentMethod.setMethodBody(currentMethodBody);
    }

    @Override
    public void exitAsPhrase(FulibScenariosParser.AsPhraseContext ctx) {
        LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>();
        String fromAttrName1 = null;
        if (ctx.fromAttrName1 != null) {
            fromAttrName1 = ctx.fromAttrName1.getText();
            map1.put(FROM_ATTR_NAME, fromAttrName1);
        }
        String fromObjName1 = null;
        if (ctx.fromObjName1 != null) {
            fromObjName1 = StrUtil.downFirstChar(ctx.fromObjName1.getText());
            map1.put(FROM_OBJ_NAME, fromObjName1);
        }
        String firstValue = this.generateRightHandValue(map1, this.previousValueDataNameList, this.previousValueDataTextList);
        firstValue = ScenarioTestCollector.truncate(firstValue, 1);
        LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>();
        String fromAttrName2 = null;
        if (ctx.fromAttrName2 != null) {
            fromAttrName2 = ctx.fromAttrName2.getText();
            map2.put(FROM_ATTR_NAME, fromAttrName2);
        }
        String cmpOp = "==";
        String text = ctx.cmp.getText();
        if (text.equals("isgreaterequal")) {
            cmpOp = ">=";
        } else if (text.equals("islessthan")) {
            cmpOp = "<=";
        }
        String fromObjName2 = null;
        if (ctx.fromObjName2 != null) {
            fromObjName2 = StrUtil.downFirstChar(ctx.fromObjName2.getText());
            map2.put(FROM_OBJ_NAME, fromObjName2);
        }
        String secondValue = this.generateRightHandValue(map2, this.valueDataNameList, this.valueDataTextList);
        secondValue = ScenarioTestCollector.truncate(secondValue, 1);
        String result = String.format(this.indent + "      if (%s %s %s) {\n", firstValue, cmpOp, secondValue);
        this.statementClosing = this.indent + "      }\n";
        this.indent = this.indent + "   ";
        this.appendToCurrentMethodBody(result);
    }

    @Override
    public void enterVerbPhrase(FulibScenariosParser.VerbPhraseContext ctx) {
        this.previousValueDataTextList = null;
        this.previousValueDataNameList = null;
        this.valueDataTextList = null;
        this.valueDataNameList = null;
    }

    @Override
    public void exitVerbPhrase(FulibScenariosParser.VerbPhraseContext ctx) {
        if (ANOTHER_ON.equals(this.loopIntro)) {
            return;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Boolean valueDataIsList = this.isList(this.valueDataNameList);
        String fromAttrName = null;
        if (ctx.fromAttrName != null) {
            fromAttrName = ctx.fromAttrName.getText();
            map.put(FROM_ATTR_NAME, fromAttrName);
        }
        String secondFromAttrName = null;
        if (ctx.secondFromAttrName != null) {
            secondFromAttrName = ctx.secondFromAttrName.getText();
            map.put(SECOND_FROM_ATTR_NAME, secondFromAttrName);
        }
        String fromObjName = null;
        if (ctx.fromObjName != null) {
            fromObjName = StrUtil.downFirstChar(ctx.fromObjName.getText());
            map.put(FROM_OBJ_NAME, fromObjName);
        }
        String toAttrName = null;
        if (ctx.toAttrName != null) {
            toAttrName = ctx.toAttrName.getText();
            map.put(TO_ATTR_NAME, toAttrName);
        }
        String toObjName = null;
        this.toObjNameList = null;
        this.toObjTextList = null;
        if (this.previousValueDataTextList != null) {
            this.toObjNameList = this.valueDataNameList;
            this.toObjTextList = this.valueDataTextList;
            this.valueDataNameList = this.previousValueDataNameList;
            this.valueDataTextList = this.previousValueDataTextList;
            toObjName = this.toObjNameList.get(0);
        }
        String rightHandValue = this.generateRightHandValue(map, this.valueDataNameList, this.valueDataTextList);
        String prepareValueList = map.get(PREPARE_VALUE_LIST);
        if (prepareValueList == null) {
            prepareValueList = "";
        }
        if (this.isList(this.valueDataNameList) && this.isList(this.toObjNameList)) {
            this.prepareLeftHandTargetList(map);
            return;
        }
        if (this.isList(this.valueDataNameList) && !this.isList(this.toObjNameList)) {
            if (toAttrName != null && toObjName == null) {
                String valueClassName = map.get(VALUE_CLASS_NAME);
                String valueListName = map.get(VALUE_LIST_NAME);
                String assignPart = String.format("" + this.indent + "      java.util.ArrayList<%s> %s = %s;\n", valueClassName, toAttrName, valueListName);
                this.appendToCurrentMethodBody(assignPart);
                return;
            }
            String assignPart = String.format("%s%s", "", "      // list to single value to be done \n");
            this.appendToCurrentMethodBody(assignPart);
            return;
        }
        String fromClassName = map.get(FROM_CLASS_NAME);
        boolean valueClassIsAttrType = map.get(VALUE_CLASS_IS_ATTR_TYPE) != null;
        String valueClassName = map.get(VALUE_CLASS_NAME);
        String entryClassName = null;
        String newVarName = map.get(NEW_VAR_NAME);
        String valueName = map.get(VALUE_NAME);
        String leftHandValue = "?";
        if (toObjName == null) {
            if (fromClassName != null) {
                AssocRole fromRole;
                Clazz fromClass = this.mm.haveClass(fromClassName);
                String index = this.indexPart(fromAttrName);
                if (index != null) {
                    fromAttrName = ScenarioTestCollector.truncate(fromAttrName, index.length());
                }
                if ((fromRole = fromClass.getRole(fromAttrName)) != null) {
                    valueClassName = fromRole.getOther().getClazz().getName();
                    if (fromRole.getCardinality() > 1 && index == null) {
                        entryClassName = valueClassName;
                        valueClassName = String.format("java.util.ArrayList<%s>", valueClassName);
                    }
                    valueClassIsAttrType = false;
                }
            }
            leftHandValue = String.format("%s %s = ", valueClassName, newVarName);
            if (this.getMethodLocalVars().get(newVarName) != null) {
                leftHandValue = String.format("%s = ", newVarName);
            }
            if (ctx.verb.getText().equals("adds")) {
                leftHandValue = leftHandValue + newVarName + " + ";
            }
            if (!valueClassIsAttrType) {
                this.object2ClassMap.put(newVarName, valueClassName);
                if (entryClassName == null) {
                    this.object2ClassMap.put(valueName, valueClassName);
                } else {
                    this.object2ClassMap.put(newVarName + "_i", entryClassName);
                    for (String v : this.valueDataNameList) {
                        this.object2ClassMap.put(v, entryClassName);
                    }
                }
            }
            this.getMethodLocalVars().put(newVarName, valueName);
        } else if (valueClassName != null && valueClassName.startsWith("java.util.ArrayList")) {
            leftHandValue = "";
        } else {
            String toVarName = this.getParamVarName4Value(StrUtil.downFirstChar(toObjName));
            leftHandValue = String.format("%s.set%s(", toVarName, StrUtil.cap(toAttrName));
            rightHandValue = rightHandValue.substring(0, rightHandValue.length() - 1) + ");";
            if (ctx.verb.getText().equals("adds")) {
                rightHandValue = String.format("%s.get%s() + " + rightHandValue, toVarName, StrUtil.cap(toAttrName));
            }
        }
        String result = String.format(this.indent + "      %s%s\n", leftHandValue, rightHandValue);
        if (LOOP_INTRO.equals(this.loopIntro)) {
            String rangeStart = map.get(RANGE_START);
            String rangeEnd = map.get(RANGE_END);
            result = String.format("      int %s = %s;\n", newVarName, rangeStart);
            result = result + String.format("      for ( ; %s <= %s; %s++) {\n", newVarName, rangeEnd, newVarName);
            this.indent = "   ";
        }
        String firstFromAttrIndex = map.get(FIRST_FROM_ATTR_INDEX);
        String secondFromAttrIndex = map.get(SECOND_FROM_ATTR_INDEX);
        if (secondFromAttrIndex != null) {
            if (toObjName == null) {
                result = String.format(this.indent + "      %snew java.util.ArrayList<>();\n", leftHandValue);
                rightHandValue = ScenarioTestCollector.truncate(rightHandValue, 1);
                result = result + String.format(this.indent + "      for (int i = %s; i <= %s; i++) {\n         %s.add(%s);\n      }\n", firstFromAttrIndex, secondFromAttrIndex, newVarName, rightHandValue);
            } else {
                String toObjVarName = this.getParamVarName4Value(toObjName);
                rightHandValue = ScenarioTestCollector.truncate(rightHandValue, ");".length());
                result = String.format(this.indent + "      for (int i = %s; i <= %s; i++) {\n         %s.with%s(%s);\n      }\n", firstFromAttrIndex, secondFromAttrIndex, toObjVarName, StrUtil.cap(newVarName), rightHandValue);
                String toObjClassName = this.object2ClassMap.get(StrUtil.downFirstChar(toObjName));
                entryClassName = map.get(ENTRY_CLASS_NAME);
                Clazz toObjClazz = this.mm.haveClass(toObjClassName);
                Clazz tgtClazz = this.mm.haveClass(entryClassName);
                this.mm.haveRole(toObjClazz, StrUtil.downFirstChar(newVarName), tgtClazz, 42);
            }
        }
        result = prepareValueList + result;
        this.appendToCurrentMethodBody(result);
    }

    private String generateRightHandValue(LinkedHashMap<String, String> map, ArrayList<String> myValueDataNameList, ArrayList<String> myValueDataTextList) {
        String secondFromAttrName;
        String toAttrName;
        String leftHandSetter = "?";
        String valueName = myValueDataNameList.get(0);
        String rangeStart = null;
        String rangeEnd = null;
        String fromListName = null;
        String index = null;
        String valueClassName = null;
        String valueListName = "tmpValueList";
        String valueAccess = "???";
        if (this.isList(myValueDataNameList)) {
            this.prepareRightHandValueList(map, valueClassName, valueListName);
            return "84";
        }
        int pos = valueName.indexOf(58);
        if (pos > 0) {
            rangeStart = valueName.substring(0, pos);
            rangeEnd = valueName.substring(pos + 1);
            map.put(RANGE_START, rangeStart);
            map.put(RANGE_END, rangeEnd);
            valueName = rangeStart;
        } else {
            String indexPart = this.indexPart(valueName);
            if (!valueName.equals(indexPart)) {
                index = indexPart;
                fromListName = valueName = ScenarioTestCollector.truncate(valueName, index.length());
            }
        }
        map.put(VALUE_NAME, valueName);
        String newVarName = valueName;
        String paramValue = this.methodLocalVars.get(newVarName);
        if (paramValue != null) {
            valueName = paramValue;
        }
        boolean valueClassIsAttrType = false;
        boolean valueClassIsDouble = false;
        valueClassName = this.object2ClassMap.get(valueName);
        String entryClassName = null;
        if (valueClassName == null) {
            valueClassName = this.getAttrType(valueName);
            valueClassIsAttrType = true;
            map.put(VALUE_CLASS_IS_ATTR_TYPE, "true");
            valueClassIsDouble = valueClassName.equals("double");
        }
        if (this.isList(myValueDataNameList)) {
            entryClassName = valueClassName;
            valueClassName = String.format("java.util.ArrayList<%s>", StrUtil.cap(valueClassName));
        }
        String fromAttrName = map.get(FROM_ATTR_NAME);
        String fromClassName = null;
        if (fromAttrName != null) {
            index = this.indexPart(fromAttrName);
            if (!SIZE.equals(valueName)) {
                fromClassName = this.object2ClassMap.get(fromAttrName);
            }
            newVarName = fromAttrName;
            if (index != null) {
                fromListName = fromAttrName = ScenarioTestCollector.truncate(fromAttrName, index.length());
                if (!SIZE.equals(valueName)) {
                    fromClassName = this.object2ClassMap.get(fromAttrName + "_i");
                }
            }
        }
        if ((toAttrName = map.get(TO_ATTR_NAME)) != null) {
            newVarName = toAttrName;
        }
        map.put(NEW_VAR_NAME, newVarName);
        String rightHandValue = "\"" + myValueDataTextList.get(0) + "\";";
        if (valueClassIsDouble || "int".equals(valueClassName)) {
            rightHandValue = valueName + ";";
        }
        if (fromAttrName != null) {
            rightHandValue = fromAttrName + ";";
        }
        if (SIZE.equals(valueName)) {
            rightHandValue = fromAttrName + ".size();";
        }
        if (!LOOP_INTRO.equals(this.loopIntro) && this.isList(myValueDataNameList)) {
            String toObjName = map.get(TO_OBJ_NAME);
            String addCall = newVarName;
            if (toObjName == null) {
                rightHandValue = "new java.util.ArrayList<>();\n";
                addCall = newVarName + ".add";
            } else {
                rightHandValue = "";
                addCall = String.format("%s.with%s", StrUtil.downFirstChar(toObjName), StrUtil.cap(toAttrName));
            }
            String cast = valueClassIsDouble ? "(double) " : "";
            for (String v : myValueDataTextList) {
                String nextAdd = String.format("      %s(%s%s);\n", addCall, cast, v);
                if (v.indexOf(58) > 0) {
                    String[] split = v.split("\\:");
                    nextAdd = String.format("      for (double d = %s; d <= %s; d++) {\n         %s(d);\n      }\n", split[0], split[1], addCall);
                }
                rightHandValue = rightHandValue + nextAdd;
            }
        }
        String fromObjName = map.get(FROM_OBJ_NAME);
        String fromObjVarName = null;
        if (fromObjName != null) {
            String fromIndex = this.indexPart(fromObjName);
            if (fromIndex == null) {
                fromObjVarName = this.getParamVarName4Value(fromObjName);
                fromClassName = this.object2ClassMap.get(fromObjName);
                rightHandValue = String.format("%s.get%s();", fromObjVarName, StrUtil.cap(fromAttrName));
                fromListName = String.format("%s.get%s()", fromObjVarName, StrUtil.cap(fromAttrName));
                Clazz fromClazz = this.mm.haveClass(fromClassName);
                AssocRole fromRole = fromClazz.getRole(fromAttrName);
                if (fromRole != null) {
                    valueClassName = fromRole.getOther().getClazz().getName();
                    if (fromRole.getCardinality() > 1) {
                        entryClassName = valueClassName;
                        valueClassName = String.format("java.util.ArrayList<%s>", valueClassName);
                    }
                }
            } else {
                String listName = fromObjName.substring(0, fromObjName.length() - fromIndex.length());
                fromObjVarName = listName + "Num-1";
                fromClassName = this.object2ClassMap.get(fromObjVarName);
                rightHandValue = String.format("%s.get(%s).get%s();", listName, fromObjVarName, StrUtil.cap(fromAttrName));
            }
            if (SIZE.equals(valueName)) {
                rightHandValue = ScenarioTestCollector.truncate(rightHandValue, ";".length()) + ".size();";
                fromClassName = null;
                valueClassName = "int";
            }
        }
        if ((secondFromAttrName = map.get(SECOND_FROM_ATTR_NAME)) != null) {
            String firstIndex;
            String secondIndex = this.indexPart(secondFromAttrName);
            if (secondIndex.startsWith("_")) {
                secondIndex = secondIndex.substring(1);
            }
            if ((firstIndex = index).startsWith("_")) {
                firstIndex = firstIndex.substring(1);
            }
            map.put(FIRST_FROM_ATTR_INDEX, firstIndex);
            map.put(SECOND_FROM_ATTR_INDEX, secondIndex);
            index = "i";
        }
        if (index != null) {
            if (index.startsWith("_")) {
                index = index.substring(1);
            }
            rightHandValue = String.format("%s.get(%s-1);", fromListName, index);
        }
        map.put(VALUE_CLASS_NAME, valueClassName);
        map.put(ENTRY_CLASS_NAME, entryClassName);
        map.put(FROM_CLASS_NAME, fromClassName);
        return rightHandValue;
    }

    private void prepareLeftHandTargetList(LinkedHashMap<String, String> map) {
        String addTargets = "";
        String targetClassName = null;
        String targetListName = null;
        for (int i = 0; i < this.toObjNameList.size(); ++i) {
            String fromListName;
            String v = this.toObjNameList.get(i);
            if (v.indexOf(58) < 0) {
                String valueAccess;
                String indexPart = this.indexPart(v);
                if (indexPart == null) {
                    valueAccess = v;
                    targetClassName = this.object2ClassMap.get(v);
                } else {
                    fromListName = ScenarioTestCollector.truncate(v, indexPart.length());
                    if (targetClassName == null) {
                        targetClassName = this.object2ClassMap.get(fromListName + "_i");
                        targetListName = String.format("tmp%sValueList", targetClassName);
                    }
                    valueAccess = String.format("%sList.get(%s-1)", fromListName, indexPart);
                }
                addTargets = addTargets + String.format("" + this.indent + "      %s.add(%s);\n", targetListName, valueAccess);
                continue;
            }
            String[] split = v.split("\\:");
            String rangeStart = this.indexPart(split[0]);
            String rangeEnd = this.indexPart(split[1]);
            fromListName = ScenarioTestCollector.truncate(split[0], rangeStart.length());
            String listValueAccess = String.format("%sList.get(i-1)", fromListName);
            if (targetClassName == null) {
                targetClassName = this.object2ClassMap.get(fromListName + "_i");
                targetListName = String.format("tmp%sTargetList", targetClassName);
            }
            addTargets = addTargets + String.format("" + this.indent + "      for (int i = %s; i <= %s; i++) {\n" + this.indent + "         %s.add(%s);\n" + this.indent + "      }\n", rangeStart, rangeEnd, targetListName, listValueAccess);
        }
        String prepareTargetList = String.format(this.indent + "      java.util.ArrayList<%s> %s = new java.util.ArrayList<>();\n", targetClassName, targetListName);
        prepareTargetList = prepareTargetList + addTargets;
        String valueListName = map.get(VALUE_LIST_NAME);
        String toAttrName = map.get(TO_ATTR_NAME);
        toAttrName = StrUtil.cap(toAttrName);
        String assignPart = String.format("" + this.indent + "      for (int i = 1; i <= %s.size(); i++) {\n" + this.indent + "         %s.get(i-1).with%s(%s.get(i-1));\n" + this.indent + "      }\n", targetListName, targetListName, toAttrName, valueListName);
        Clazz targetClazz = this.mm.haveClass(targetClassName);
        String valueClassName = map.get(VALUE_CLASS_NAME);
        Clazz valueClazz = this.mm.haveClass(valueClassName);
        this.mm.haveRole(targetClazz, toAttrName, valueClazz, 42);
        map.put(PREPARE_TARGET_LIST, prepareTargetList);
        this.appendToCurrentMethodBody(prepareTargetList + assignPart + "\n");
    }

    private void prepareRightHandValueList(LinkedHashMap<String, String> map, String valueClassName, String valueListName) {
        String addValues = "";
        for (int i = 0; i < this.valueDataNameList.size(); ++i) {
            String fromListName;
            String v = this.valueDataNameList.get(i);
            if (v.indexOf(58) < 0) {
                String valueAccess;
                String indexPart = this.indexPart(v);
                if (indexPart == null) {
                    valueAccess = v;
                    valueClassName = this.object2ClassMap.get(v);
                    if (valueClassName == null && "String".equals(valueClassName = this.getAttrType(v))) {
                        valueAccess = "\"" + v + "\"";
                    }
                } else {
                    fromListName = ScenarioTestCollector.truncate(v, indexPart.length());
                    if (valueClassName == null) {
                        valueClassName = this.object2ClassMap.get(fromListName + "_i");
                        valueListName = String.format("tmp%sValueList", valueClassName);
                    }
                    valueAccess = String.format("%sList.get(%s-1)", fromListName, indexPart);
                }
                addValues = addValues + String.format("" + this.indent + "      %s.add(%s);\n", valueListName, valueAccess);
                continue;
            }
            String[] split = v.split("\\:");
            String rangeStart = this.indexPart(split[0]);
            String rangeEnd = this.indexPart(split[1]);
            fromListName = ScenarioTestCollector.truncate(split[0], rangeStart.length());
            String listValueAccess = String.format("%sList.get(i-1)", fromListName);
            if ("".equals(fromListName)) {
                valueClassName = "Integer";
                valueListName = "tmpIntValueList";
                listValueAccess = "i";
            }
            if (valueClassName == null) {
                valueClassName = this.object2ClassMap.get(fromListName + "_i");
                valueListName = String.format("tmp%sValueList", valueClassName);
            }
            addValues = addValues + String.format("" + this.indent + "      for (int i = %s; i <= %s; i++) {\n" + this.indent + "         %s.add(%s);\n" + this.indent + "      }\n", rangeStart, rangeEnd, valueListName, listValueAccess);
        }
        String prepareValueList = String.format(this.indent + "      java.util.ArrayList<%s> %s = new java.util.ArrayList<>();\n", valueClassName, valueListName);
        prepareValueList = prepareValueList + addValues;
        map.put(VALUE_CLASS_NAME, valueClassName);
        map.put(VALUE_LIST_NAME, valueListName);
        map.put(PREPARE_VALUE_LIST, prepareValueList);
        this.appendToCurrentMethodBody(prepareValueList);
    }

    private static String truncate(String oldText, int charsToChop) {
        oldText = oldText.substring(0, oldText.length() - charsToChop);
        return oldText;
    }

    private String indexPart(String valueName) {
        Pattern regEx = Pattern.compile("(([0-9]+)|(_[a-zA-Z]*))$");
        Matcher matcher = regEx.matcher(valueName);
        boolean found = matcher.find();
        if (found) {
            String group = matcher.group();
            return group;
        }
        return null;
    }

    private boolean isList(ArrayList<String> nameList) {
        if (nameList == null) {
            return false;
        }
        if (nameList.size() > 1) {
            return true;
        }
        return nameList.get(0).indexOf(58) > 0;
    }

    private String setMethodName(String obj, String attrName, String value) {
        String objectType = this.object2ClassMap.get(obj);
        Clazz objectClass = this.mm.haveClass(objectType);
        String valueType = this.object2ClassMap.get(value);
        if (valueType == null) {
            AssocRole role = objectClass.getRole(attrName);
            valueType = role.getOther().getClazz().getName();
        }
        Clazz valueClass = this.mm.haveClass(valueType);
        AssocRole role = this.mm.haveRole(objectClass, attrName, valueClass, 1);
        String prefix = "with";
        if (role.getCardinality() == 1) {
            prefix = "set";
        }
        return prefix + StrUtil.cap(attrName);
    }

    private String realValue(String value) {
        String ownerId = StrUtil.downFirstChar(value);
        if (this.object2ClassMap.get(ownerId) != null) {
            value = ownerId;
        }
        return value;
    }

    @Override
    public void exitAnswerPhrase(FulibScenariosParser.AnswerPhraseContext ctx) {
        String resultType;
        String oneReturnValue = this.valueDataTextList.get(0);
        String[] returnValueList = oneReturnValue.split(" ");
        String returnValue = ctx.value.getText();
        String returnValueId = StrUtil.downFirstChar(returnValue);
        if (returnValueList.length == 2) {
            returnValue = returnValueList[1];
            returnValueId = StrUtil.downFirstChar(returnValue);
            this.mm.haveClass(returnValueList[0]);
            this.object2ClassMap.put(returnValueId, returnValueList[0]);
        }
        if ((resultType = this.object2ClassMap.get(returnValueId)) != null) {
            returnValue = returnValueId;
        }
        if (this.currentMethod.getMethodBody() != null) {
            String result = String.format("      return %s;\n", returnValue);
            this.currentMethod.writeReturnType(resultType);
            this.appendToCurrentMethodBody(result);
        }
        String newCallStatement = String.format("%s %s = %s", resultType, returnValue, this.lastInvocation);
        int pos = this.methodBody.lastIndexOf(this.lastInvocation);
        this.methodBody.replace(pos, pos + this.lastInvocation.length(), newCallStatement);
    }

    @Override
    public void enterThatPhrase(FulibScenariosParser.ThatPhraseContext ctx) {
        this.sentenceType = "thatPhrase";
    }

    @Override
    public void enterNumberHasClause(FulibScenariosParser.NumberHasClauseContext ctx) {
        super.enterNumberHasClause(ctx);
    }

    @Override
    public void exitThatPhrase(FulibScenariosParser.ThatPhraseContext ctx) {
        this.sentenceType = null;
        String objectName = StrUtil.downFirstChar(ctx.objectName.getText());
        if (ctx.hasPart instanceof FulibScenariosParser.UsualHasClauseContext) {
            FulibScenariosParser.UsualHasClauseContext hasCtx = (FulibScenariosParser.UsualHasClauseContext)ctx.hasPart;
            String attrName = hasCtx.attrName.getText();
            String objectType = this.object2ClassMap.get(objectName);
            Clazz objectClass = this.mm.haveClass(objectType);
            AssocRole role = objectClass.getRole(attrName);
            String checkOp = "hasItem";
            if (role == null || role.getCardinality() == 1) {
                checkOp = "equalTo";
            }
            String value = this.valueDataTextList.get(0);
            if (this.object2ClassMap.get(value = this.realValue(value)) == null) {
                value = this.getAttrType(value).equals("String") ? "\"" + value + "\"" : "(double) " + value;
            }
            String result = String.format("assertThat(%s.get%s(), %s(%s));\n", objectName, StrUtil.cap(attrName), checkOp, value);
            this.methodBody.append(result);
            this.references.setLength(0);
            System.out.println();
        }
    }

    @Override
    public void enterUsualWithClause(FulibScenariosParser.UsualWithClauseContext ctx) {
        this.attrName = ctx.attrName.getText();
        ArrayList<String> valueList = this.getValueList(ctx.attrValue);
        this.attrValue = this.getMultiValue(ctx.attrValue);
        if (ctx.children.get(ctx.children.size() - 1) instanceof TerminalNode) {
            this.attrValue = ScenarioTestCollector.truncate(this.attrValue, 3);
        }
        this.attrValue = this.attrValue.trim();
        if (this.attrValue.endsWith(",")) {
            this.attrValue = ScenarioTestCollector.truncate(this.attrValue, 1);
        }
    }

    @Override
    public void enterUsualHasClause(FulibScenariosParser.UsualHasClauseContext ctx) {
        this.attrName = ctx.attrName.getText();
        this.attrValue = ctx.attrValue.getText();
        if (ctx.children.get(ctx.children.size() - 1) instanceof TerminalNode) {
            this.attrValue = ScenarioTestCollector.truncate(this.attrValue, 3);
        }
        this.attrValue = this.attrValue.trim();
        if (this.attrValue.endsWith(",")) {
            this.attrValue = ScenarioTestCollector.truncate(this.attrValue, 1);
        }
    }

    @Override
    public void exitUsualWithClause(FulibScenariosParser.UsualWithClauseContext ctx) {
        if (this.sentenceType == null) {
            this.computeSettings();
        } else if (this.sentenceType.equals(VERB_PHRASE)) {
            String attrName = this.attrName;
            ArrayList<String> valueList = new ArrayList<String>();
            for (int i = 0; i < this.valueDataNameList.size(); ++i) {
                String value = this.valueDataNameList.get(i);
                if (this.object2ClassMap.get(value) == null) {
                    valueList.add(this.valueDataTextList.get(i));
                    continue;
                }
                valueList.add(value);
            }
            this.currentAttrValueMap.put(attrName, valueList);
        } else {
            String attrName = this.attrName;
            String value = this.attrValue;
            String objName = StrUtil.downFirstChar(value);
            if (this.object2ClassMap.get(objName) != null) {
                this.methodParams.put(attrName, objName);
                this.methodLocalVars.put(attrName, objName);
            } else {
                this.methodParams.put(attrName, value);
                this.methodLocalVars.put(attrName, value);
            }
        }
    }

    private String computeFullSetterCall(String className, Clazz newClazz, String newObjectName, String attr, String attrType, String newValue) {
        String result = "";
        String newParam = this.getParamVarName4Value(newValue);
        STGroupFile group = new STGroupFile("templates/junitTest.stg");
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        if (!newObjectName.equals(newValue) && this.object2ClassMap.get(newValue) != null) {
            String tgtClassName = this.object2ClassMap.get(newValue);
            Clazz tgtClass = this.mm.haveClass(tgtClassName);
            AssocRole role = this.mm.haveRole(newClazz, attr, tgtClass, 1);
            this.addAttrValueExample(className, attr, newValue);
            String stmt = "      " + newObjectName + ".";
            stmt = role.getCardinality() == 1 ? stmt + "set" : stmt + "with";
            stmt = stmt + StrUtil.cap(attr);
            stmt = stmt + "(" + newParam + ");\n";
            result = result + stmt;
        } else {
            this.mm.haveAttribute(newClazz, attr, attrType);
            String actualParam = newParam;
            if (newParam.equals(newValue) && attrType.equals("String") && newValue.indexOf(".") < 0) {
                actualParam = "\"" + newValue + "\"";
            }
            ST st = group.getInstanceOf("fullSetting");
            st.add("objectName", (Object)newObjectName);
            st.add("attrName", (Object)StrUtil.cap(attr));
            st.add("attrValue", (Object)actualParam);
            String text = st.render();
            if (newValue.indexOf(".") < 0) {
                this.addAttrValueExample(className, attr, newValue);
            }
            result = result + text;
        }
        return result;
    }

    private String getAttrType(String newValue) {
        if (SIZE.equals(newValue)) {
            return "int";
        }
        String attrType = "String";
        try {
            NumberFormat.getInstance().parse(newValue);
            attrType = "double";
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return attrType;
    }

    private void computeSettings() {
        STGroupFile group = new STGroupFile("templates/junitTest.stg");
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        ST st = group.getInstanceOf("setting");
        boolean buildAttr = false;
        if (this.objectName == null) {
            this.objectName = this.valueDataNameList.get(0);
            buildAttr = true;
        }
        if (!buildAttr && this.object2ClassMap.get(this.valueDataNameList.get(0)) != null) {
            String srcClassName = this.object2ClassMap.get(this.objectName);
            if (srcClassName == null) {
                throw new RuntimeException("Could not find class for " + this.objectName);
            }
            Clazz srcClass = this.mm.haveClass(srcClassName);
            String tgtClassName = this.object2ClassMap.get(this.valueDataNameList.get(0));
            Clazz tgtClass = this.mm.haveClass(tgtClassName);
            AssocRole role = this.mm.haveRole(srcClass, this.attrName, tgtClass, this.valueDataNameList.size());
            String stmt = this.objectName + ".";
            stmt = role.getCardinality() == 1 ? stmt + "set" : stmt + "with";
            stmt = stmt + StrUtil.cap(this.attrName);
            stmt = stmt + "(";
            for (String name : this.valueDataNameList) {
                stmt = stmt + name + ", ";
                this.addAttrValueExample(srcClassName, this.attrName, name);
            }
            stmt = ScenarioTestCollector.truncate(stmt, 2);
            stmt = stmt + ");\n";
            this.references.append(stmt);
        } else {
            this.mm.haveAttribute(this.clazz, this.attrName, "String");
            st.add("attrName", (Object)StrUtil.cap(this.attrName));
            String value = this.valueDataTextList.get(0);
            st.add("attrValue", (Object)("\"" + value + "\""));
            String result = st.render();
            this.addAttrValueExample(this.className, this.attrName, value);
            this.settings.append(result);
        }
    }

    private void addAttrValueExample(String className, String attrName, String value) {
        String key = className + "." + attrName;
        TreeSet<String> exampleSet = this.attrValueExamplesMap.get(key);
        if (exampleSet == null) {
            exampleSet = new TreeSet();
            this.attrValueExamplesMap.put(key, exampleSet);
        }
        exampleSet.add(value);
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<String> computeInitialization(String objectName, String className) {
        STGroupFile group = new STGroupFile("templates/junitTest.stg");
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        Clazz newClazz = this.getModelManager().haveClass(className);
        ArrayList<String> resultList = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<String>> entry : this.currentAttrValueMap.entrySet()) {
            void var12_12;
            String key = entry.getKey();
            ArrayList<String> valueList = entry.getValue();
            ArrayList<String> valueIdList = new ArrayList<String>();
            for (String string : valueList) {
                valueIdList.add(StrUtil.downFirstChar(string));
            }
            ArrayList<String> paramValueList = new ArrayList<String>();
            for (String v3 : valueList) {
                paramValueList.add(this.getParamVarName4Value(v3));
            }
            boolean bl = false;
            while (var12_12 < valueList.size()) {
                String result = "";
                String valueId = (String)valueIdList.get((int)var12_12);
                String value = valueList.get((int)var12_12);
                if (!valueId.equals(objectName) && this.object2ClassMap.get(valueId) != null) {
                    String tgtClassName = this.object2ClassMap.get(valueId);
                    Clazz tgtClass = this.mm.haveClass(tgtClassName);
                    AssocRole role = this.mm.haveRole(newClazz, key, tgtClass, this.valueDataNameList.size());
                    String stmt = "\n         .";
                    stmt = role.getCardinality() == 1 ? stmt + "set" : stmt + "with";
                    stmt = stmt + StrUtil.cap(key);
                    stmt = stmt + "(";
                    String param = this.getParamVarName4Value(valueId);
                    this.addAttrValueExample(className, key, valueId);
                    stmt = stmt + param;
                    stmt = stmt + ")";
                    result = result + stmt;
                } else {
                    this.mm.haveAttribute(newClazz, key, "String");
                    ST st = group.getInstanceOf("setting");
                    st.add("attrName", (Object)StrUtil.cap(key));
                    st.add("attrValue", (Object)("\"" + value + "\""));
                    String text = st.render();
                    this.addAttrValueExample(className, key, value);
                    result = result + text;
                }
                resultList.add(result);
                ++var12_12;
            }
        }
        return resultList;
    }

    private String getParamVarName4Value(String value) {
        String result = value;
        for (Map.Entry<String, String> entry : this.getMethodLocalVars().entrySet()) {
            String key = entry.getKey();
            String paramValue = entry.getValue();
            if (!paramValue.equalsIgnoreCase(value)) continue;
            return key;
        }
        return result;
    }

    @Override
    public void exitUsualHasClause(FulibScenariosParser.UsualHasClauseContext ctx) {
        if (this.sentenceType == null) {
            this.computeSettings();
        }
    }

    @Override
    public void enterNumberWithClause(FulibScenariosParser.NumberWithClauseContext ctx) {
        STGroupFile group = new STGroupFile("templates/junitTest.stg");
        group.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        ST st = group.getInstanceOf("setting");
        String attrName = StrUtil.downFirstChar(this.getMultiName(ctx.attrName));
        String value = ctx.value.getText();
        this.mm.haveAttribute(this.clazz, attrName, "double");
        st.add("attrName", (Object)StrUtil.cap(attrName));
        st.add("attrValue", (Object)value);
        String result = st.render();
        this.addAttrValueExample(this.className, attrName, value);
        this.settings.append(result);
    }

    @Override
    public void enterValueClause(FulibScenariosParser.ValueClauseContext ctx) {
        this.previousValueDataTextList = this.valueDataTextList;
        this.previousValueDataNameList = this.valueDataNameList;
        this.valueDataTextList = new ArrayList();
        this.valueDataNameList = new ArrayList();
    }

    @Override
    public void exitRangeClause(FulibScenariosParser.RangeClauseContext ctx) {
        if (ctx.secondData != null) {
            int pos = this.valueDataNameList.size() - 2;
            String first = this.valueDataNameList.get(pos);
            String second = this.valueDataNameList.get(pos + 1);
            this.valueDataNameList.set(pos, first + ":" + second);
            this.valueDataNameList.remove(pos + 1);
            first = this.valueDataTextList.get(pos);
            second = this.valueDataTextList.get(pos + 1);
            this.valueDataTextList.set(pos, first + ":" + second);
            this.valueDataTextList.remove(pos + 1);
        }
    }

    @Override
    public void enterValueData(FulibScenariosParser.ValueDataContext ctx) {
        String valueText = "";
        String valueName = "";
        for (ParseTree child : ctx.children) {
            valueText = valueText + child.getText() + " ";
            valueName = valueName + StrUtil.cap(child.getText());
        }
        valueText = ScenarioTestCollector.truncate(valueText, 1);
        valueName = StrUtil.downFirstChar(valueName);
        this.valueDataTextList.add(valueText);
        this.valueDataNameList.add(valueName);
    }

    @Override
    public void enterClassDef(FulibScenariosParser.ClassDefContext ctx) {
        String className = ctx.className.getText();
        this.currentRegisterClazz = this.mm.haveClass(className);
    }

    @Override
    public void enterAttrDef(FulibScenariosParser.AttrDefContext ctx) {
        String myAttrName = ctx.attrName.getText();
        this.mm.haveAttribute(this.currentRegisterClazz, myAttrName, this.attrType);
    }

    @Override
    public void enterRoleDef(FulibScenariosParser.RoleDefContext ctx) {
        int srcSize;
        String srcRole = ctx.roleName.getText();
        String tgtClassName = StrUtil.cap(ctx.className.getText());
        Clazz tgtClass = this.mm.haveClass(tgtClassName);
        int n = srcSize = ctx.card.getText().equals("one") ? 1 : 42;
        if (ctx.otherRoleName != null) {
            String tgtRole = ctx.otherRoleName.getText();
            this.mm.haveRole(this.currentRegisterClazz, srcRole, tgtClass, srcSize, tgtRole, 1);
        } else {
            this.mm.haveRole(this.currentRegisterClazz, srcRole, tgtClass, srcSize);
        }
    }

    @Override
    public void enterExampleValue(FulibScenariosParser.ExampleValueContext ctx) {
        if (ctx.nameValue != null) {
            this.attrType = "String";
        }
        if (ctx.numberValue != null) {
            this.attrType = "double";
        }
    }

    private String getMultiName(FulibScenariosParser.MultiNameContext objectName) {
        String result = "";
        for (ParseTree child : objectName.children) {
            result = result + StrUtil.cap(child.getText());
        }
        return result;
    }

    private void getValueClauseAsName(FulibScenariosParser.UsualWithClauseContext ctx) {
        String result = "";
        for (ParseTree child : ctx.attrValue.children) {
            if (child instanceof TerminalNode) continue;
            result = result + StrUtil.cap(child.getText());
        }
        if (result.endsWith(",")) {
            result = ScenarioTestCollector.truncate(result, 1);
        }
        if (this.objectName == null) {
            this.objectName = StrUtil.downFirstChar(result);
        }
    }

    private void getValueClauseAsName(FulibScenariosParser.UsualHasClauseContext ctx) {
        String result = "";
        for (ParseTree child : ctx.attrValue.children) {
            result = result + StrUtil.cap(child.getText());
        }
        if (result.endsWith(",")) {
            result = ScenarioTestCollector.truncate(result, 1);
        }
        if (this.objectName == null) {
            this.objectName = StrUtil.downFirstChar(result);
        }
    }

    private ArrayList<String> getValueList(FulibScenariosParser.ValueClauseContext valueContext) {
        ArrayList<String> result = new ArrayList<String>();
        String oneValue = "";
        for (ParseTree child : valueContext.children) {
            if (!(child instanceof TerminalNode)) {
                oneValue = oneValue + child.getText() + " ";
                continue;
            }
            String multiName = oneValue.trim();
            if (!multiName.equals("")) {
                result.add(multiName);
            }
            oneValue = "";
        }
        String multiName = oneValue.trim();
        if (!multiName.equals("")) {
            result.add(multiName);
        }
        oneValue = "";
        return result;
    }

    private String getMultiValue(FulibScenariosParser.ValueClauseContext valueContext) {
        String result = "";
        for (ParseTree child : valueContext.children) {
            if (child instanceof TerminalNode) continue;
            result = result + StrUtil.cap(child.getText()) + " ";
        }
        return result.trim();
    }
}

