/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.transform;

import java.util.List;
import org.fulib.scenarios.ast.sentence.Sentence;

class Frame {
    String key;
    List<Sentence> target;
    Frame next;

    Frame() {
    }

    boolean keyMatches(String keys) {
        return Frame.keyMatches(this.key, keys);
    }

    static boolean keyMatches(String frameKeys, String keys) {
        int end;
        int start = 0;
        while ((end = keys.indexOf(44, start)) >= 0) {
            int colon = keys.indexOf(58, start);
            assert (colon < end);
            String key = keys.substring(start, colon + 1);
            int keyPos = frameKeys.indexOf(key);
            if (keyPos >= 0 && !frameKeys.regionMatches(keyPos, keys, start, end - start + 1)) {
                return false;
            }
            start = end + 1;
        }
        return true;
    }

    Frame add(Sentence sentence) {
        this.target.add(sentence);
        return this;
    }

    Frame add(String key, Sentence sentence) {
        return this.popIncompatible(key).add(sentence);
    }

    Frame addLast(String key, Sentence sentence) {
        return this.add(key, sentence).popToDefinition(key).pop();
    }

    Frame push(String key, List<Sentence> target) {
        Frame newTop = new Frame();
        newTop.key = key;
        newTop.target = target;
        newTop.next = this;
        return newTop;
    }

    Frame pop() {
        return this.next;
    }

    Frame popIncompatible(String key) {
        Frame result = this;
        while (!Frame.keyMatches(key, result.key)) {
            result = result.next;
        }
        return result;
    }

    Frame popToDefinition(String key) {
        Frame result = this;
        while (!result.key.contains(key)) {
            result = result.next;
        }
        return result;
    }
}

