/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.transform;

import java.util.ArrayList;
import java.util.List;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.CallSentence;
import org.fulib.scenarios.ast.sentence.CreateSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.ThereSentence;
import org.fulib.scenarios.transform.Frame;
import org.fulib.scenarios.transform.Namer;

public enum Grouper implements ScenarioGroup.Visitor<Object, Object>,
ScenarioFile.Visitor<Object, Object>,
Scenario.Visitor<Object, Object>,
Sentence.Visitor<Frame, Frame>
{
    INSTANCE;

    private static String ACTOR_TEST;

    private static String actorKey(Name name) {
        return name == null ? ACTOR_TEST : "actor:" + name.accept(Namer.INSTANCE, null) + ",";
    }

    @Override
    public Object visit(ScenarioGroup scenarioGroup, Object par) {
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            file.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(ScenarioFile scenarioFile, Object par) {
        for (Scenario scenario : scenarioFile.getScenarios().values()) {
            scenario.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(Scenario scenario, Object par) {
        Frame top = new Frame();
        top.key = ACTOR_TEST;
        top.target = new ArrayList<Sentence>();
        scenario.getBody().accept(this, top);
        scenario.getBody().setItems(top.target);
        return null;
    }

    @Override
    public Frame visit(Sentence sentence, Frame par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Frame visit(SentenceList sentenceList, Frame par) {
        for (Sentence item : sentenceList.getItems()) {
            par = item.accept(this, par);
        }
        return par;
    }

    @Override
    public Frame visit(ThereSentence thereSentence, Frame par) {
        return par.add(ACTOR_TEST, thereSentence);
    }

    @Override
    public Frame visit(ExpectSentence expectSentence, Frame par) {
        return par.add(ACTOR_TEST, expectSentence);
    }

    @Override
    public Frame visit(DiagramSentence diagramSentence, Frame par) {
        return par.add(ACTOR_TEST, diagramSentence);
    }

    @Override
    public Frame visit(HasSentence hasSentence, Frame par) {
        return par.add(hasSentence);
    }

    @Override
    public Frame visit(IsSentence isSentence, Frame par) {
        return par.add(isSentence);
    }

    @Override
    public Frame visit(CreateSentence createSentence, Frame par) {
        return par.add(Grouper.actorKey(createSentence.getActor()), createSentence);
    }

    @Override
    public Frame visit(CallSentence callSentence, Frame par) {
        CallExpr callExpr = callSentence.getCall();
        List<Sentence> sentences = callExpr.getBody().getItems();
        return par.add(Grouper.actorKey(callSentence.getActor()), callSentence).push(Grouper.actorKey(callExpr.getName()), sentences);
    }

    @Override
    public Frame visit(AnswerSentence answerSentence, Frame par) {
        return par.addLast(Grouper.actorKey(answerSentence.getActor()), answerSentence);
    }

    @Override
    public Frame visit(ExprSentence exprSentence, Frame par) {
        return par.add(exprSentence);
    }

    static {
        ACTOR_TEST = "actor:<test>,";
    }
}

