/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.transform;

import java.util.List;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.CollectionExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.NumberLiteral;
import org.fulib.scenarios.ast.expr.primary.PrimaryExpr;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.transform.Namer;

public final class Typer
extends Enum<Typer>
implements Expr.Visitor<Object, String>,
Name.Visitor<Object, String> {
    public static final /* enum */ Typer INSTANCE = new Typer();
    private static final /* synthetic */ Typer[] $VALUES;

    public static Typer[] values() {
        return (Typer[])$VALUES.clone();
    }

    public static Typer valueOf(String name) {
        return Enum.valueOf(Typer.class, name);
    }

    @Override
    public String visit(Expr expr, Object par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String visit(AttributeAccess attributeAccess, Object par) {
        return attributeAccess.getName().accept(this, par);
    }

    @Override
    public String visit(ExampleAccess exampleAccess, Object par) {
        return exampleAccess.getExpr().accept(this, par);
    }

    @Override
    public String visit(CreationExpr creationExpr, Object par) {
        return StrUtil.cap(creationExpr.getClassName().accept(Namer.INSTANCE, null));
    }

    @Override
    public String visit(CallExpr callExpr, Object par) {
        Sentence lastSentence;
        List<Sentence> body = callExpr.getBody().getItems();
        if (!body.isEmpty() && (lastSentence = body.get(body.size() - 1)) instanceof AnswerSentence) {
            Expr result = ((AnswerSentence)lastSentence).getResult();
            return result.accept(this, null);
        }
        return "void";
    }

    @Override
    public String visit(PrimaryExpr primaryExpr, Object par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String visit(NameAccess nameAccess, Object par) {
        return nameAccess.getName().accept(this, par);
    }

    @Override
    public String visit(NumberLiteral numberLiteral, Object par) {
        return "double";
    }

    @Override
    public String visit(StringLiteral stringLiteral, Object par) {
        return "String";
    }

    @Override
    public String visit(ConditionalExpr conditionalExpr, Object par) {
        return "boolean";
    }

    @Override
    public String visit(AttributeCheckExpr attributeCheckExpr, Object par) {
        return "boolean";
    }

    @Override
    public String visit(CollectionExpr collectionExpr, Object par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String visit(ListExpr listExpr, Object par) {
        String commonType = null;
        for (Expr element : listExpr.getElements()) {
            String elementType = element.accept(this, par);
            if (commonType == null) {
                commonType = elementType;
                continue;
            }
            if (commonType.equals(elementType)) continue;
            return "List<Object>";
        }
        assert (commonType != null) : "empty list expression";
        return "List<" + Typer.primitiveToWrapper(commonType) + ">";
    }

    @Override
    public String visit(Name name, Object par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String visit(UnresolvedName unresolvedName, Object par) {
        throw new IllegalStateException("unresolved name " + unresolvedName.getValue());
    }

    @Override
    public String visit(ResolvedName resolvedName, Object par) {
        return resolvedName.getDecl().getType();
    }

    public static String primitiveToWrapper(String primitive) {
        switch (primitive) {
            case "byte": {
                return "Byte";
            }
            case "short": {
                return "Short";
            }
            case "char": {
                return "Character";
            }
            case "int": {
                return "Integer";
            }
            case "long": {
                return "Long";
            }
            case "float": {
                return "Float";
            }
            case "double": {
                return "Double";
            }
            case "void": {
                return "Void";
            }
        }
        return primitive;
    }

    static {
        $VALUES = new Typer[]{INSTANCE};
    }
}

