package org.fulib.scenarios.ast.decl;

import org.fulib.scenarios.ast.Node;


public interface ParameterDecl extends Decl
{
	// =============== Static Methods ===============
	static ParameterDecl of(MethodDecl owner, String name, String type) { return new Impl(owner, name, type); }
	// =============== Properties ===============
	MethodDecl getOwner();
	void setOwner(MethodDecl owner);
	String getName();
	void setName(String name);
	String getType();
	void setType(String type);

	// =============== Methods ===============
	<P, R> R accept(ParameterDecl.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements ParameterDecl
	{
		// =============== Fields ===============
		private MethodDecl owner;
		private String name;
		private String type;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(MethodDecl owner, String name, String type)
		{
			this.owner = owner;
			this.name = name;
			this.type = type;
		}

		// =============== Properties ===============
		@Override public MethodDecl getOwner() { return this.owner; }
		@Override public void setOwner(MethodDecl owner) { this.owner = owner; }
		@Override public String getName() { return this.name; }
		@Override public void setName(String name) { this.name = name; }
		@Override public String getType() { return this.type; }
		@Override public void setType(String type) { this.type = type; }

		// =============== Methods ===============
		@Override public <P, R> R accept(ParameterDecl.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Decl.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(ParameterDecl parameterDecl, P par);
	}
}
