package org.fulib.scenarios.ast.sentence;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.expr.Expr;


public interface DiagramSentence extends Sentence
{
	// =============== Static Methods ===============
	static DiagramSentence of(Expr object, String fileName) { return new Impl(object, fileName); }
	// =============== Properties ===============
	Expr getObject();
	void setObject(Expr object);
	String getFileName();
	void setFileName(String fileName);

	// =============== Methods ===============
	<P, R> R accept(DiagramSentence.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements DiagramSentence
	{
		// =============== Fields ===============
		private Expr object;
		private String fileName;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(Expr object, String fileName)
		{
			this.object = object;
			this.fileName = fileName;
		}

		// =============== Properties ===============
		@Override public Expr getObject() { return this.object; }
		@Override public void setObject(Expr object) { this.object = object; }
		@Override public String getFileName() { return this.fileName; }
		@Override public void setFileName(String fileName) { this.fileName = fileName; }

		// =============== Methods ===============
		@Override public <P, R> R accept(DiagramSentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Sentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(DiagramSentence diagramSentence, P par);
	}
}
