package org.fulib.scenarios.ast.sentence;

import java.util.List;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;


public interface ExpectSentence extends Sentence
{
	// =============== Static Methods ===============
	static ExpectSentence of(List<ConditionalExpr> predicates) { return new Impl(predicates); }
	// =============== Properties ===============
	List<ConditionalExpr> getPredicates();
	void setPredicates(List<ConditionalExpr> predicates);

	// =============== Methods ===============
	<P, R> R accept(ExpectSentence.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements ExpectSentence
	{
		// =============== Fields ===============
		private List<ConditionalExpr> predicates;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(List<ConditionalExpr> predicates)
		{
			this.predicates = predicates;
		}

		// =============== Properties ===============
		@Override public List<ConditionalExpr> getPredicates() { return this.predicates; }
		@Override public void setPredicates(List<ConditionalExpr> predicates) { this.predicates = predicates; }

		// =============== Methods ===============
		@Override public <P, R> R accept(ExpectSentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Sentence.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(ExpectSentence expectSentence, P par);
	}
}
