/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.codegen;

import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalExpr;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.CallSentence;
import org.fulib.scenarios.ast.sentence.CreateSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.ThereSentence;
import org.fulib.scenarios.codegen.AssertionGenerator;
import org.fulib.scenarios.codegen.CodeGenerator;
import org.fulib.scenarios.codegen.DeclGenerator;
import org.fulib.scenarios.codegen.ExprGenerator;

public enum SentenceGenerator implements Sentence.Visitor<CodeGenerator, Object>
{
    INSTANCE;


    @Override
    public Object visit(Sentence sentence, CodeGenerator par) {
        return null;
    }

    @Override
    public Object visit(SentenceList sentenceList, CodeGenerator par) {
        for (Sentence item : sentenceList.getItems()) {
            item.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(ThereSentence thereSentence, CodeGenerator par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visit(ExpectSentence expectSentence, CodeGenerator par) {
        for (ConditionalExpr expr : expectSentence.getPredicates()) {
            par.emitIndent();
            expr.accept(AssertionGenerator.INSTANCE, par);
            par.bodyBuilder.append(";\n");
        }
        return null;
    }

    @Override
    public Object visit(DiagramSentence diagramSentence, CodeGenerator par) {
        String format;
        String sourceDir = par.group.getSourceDir();
        String packageDir = par.group.getPackageDir();
        String fileName = diagramSentence.getFileName();
        String string = format = fileName.endsWith(".svg") ? "SVG" : "Png";
        if (fileName.endsWith("yaml")) {
            format = "Yaml";
        }
        String target = sourceDir + "/" + packageDir + "/" + fileName;
        target = target.replaceAll("\\\\", "/");
        par.addImport("org.fulib.FulibTools");
        par.emitIndent();
        par.bodyBuilder.append("FulibTools.objectDiagrams().dump").append(format).append("(");
        par.emitStringLiteral(target);
        par.bodyBuilder.append(", ");
        diagramSentence.getObject().accept(ExprGenerator.NO_LIST, par);
        par.bodyBuilder.append(");\n");
        return null;
    }

    @Override
    public Object visit(HasSentence hasSentence, CodeGenerator par) {
        par.emitIndent();
        hasSentence.getObject().accept(ExprGenerator.INSTANCE, par);
        for (NamedExpr attribute : hasSentence.getClauses()) {
            ExprGenerator.generateSetterCall(par, attribute);
        }
        par.bodyBuilder.append(";\n");
        return null;
    }

    @Override
    public Object visit(IsSentence isSentence, CodeGenerator par) {
        isSentence.getDescriptor().accept(DeclGenerator.INSTANCE, par);
        return null;
    }

    @Override
    public Object visit(CreateSentence createSentence, CodeGenerator par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visit(CallSentence callSentence, CodeGenerator par) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visit(AnswerSentence answerSentence, CodeGenerator par) {
        par.emitIndent();
        par.bodyBuilder.append("return ");
        answerSentence.getResult().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(";\n");
        return null;
    }

    @Override
    public Object visit(ExprSentence exprSentence, CodeGenerator par) {
        par.emitIndent();
        exprSentence.getExpr().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(";\n");
        return null;
    }
}

