/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.compiler;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.fulib.StrUtil;
import org.fulib.scenarios.parser.FulibScenariosBaseListener;
import org.fulib.scenarios.parser.FulibScenariosParser;

public class ScenarioObjectCollector
extends FulibScenariosBaseListener {
    public LinkedHashMap<String, String> object2ClassMap = new LinkedHashMap();
    private String objectName;
    private String className;
    private ArrayList<String> objectNamesList = new ArrayList();

    @Override
    public void enterDirectSentence(FulibScenariosParser.DirectSentenceContext ctx) {
        this.objectName = StrUtil.downFirstChar(this.getMultiName(ctx.objectName));
        this.className = StrUtil.cap(this.getMultiName(ctx.className));
        this.object2ClassMap.put(this.objectName, this.className);
    }

    @Override
    public void enterThereSentence(FulibScenariosParser.ThereSentenceContext ctx) {
        this.objectName = null;
        if (ctx.objectName != null) {
            this.objectName = StrUtil.downFirstChar(this.getMultiName(ctx.objectName));
        }
        this.className = ctx.className == null ? StrUtil.cap(this.objectName) : StrUtil.cap(ctx.className.getText());
    }

    @Override
    public void enterHasSentence(FulibScenariosParser.HasSentenceContext ctx) {
        this.objectName = null;
        if (ctx.objectName != null) {
            this.objectName = StrUtil.downFirstChar(this.getMultiName(ctx.objectName));
        }
    }

    @Override
    public void exitThereSentence(FulibScenariosParser.ThereSentenceContext ctx) {
        this.object2ClassMap.put(this.objectName, this.className);
    }

    @Override
    public void enterUsualWithClause(FulibScenariosParser.UsualWithClauseContext ctx) {
        this.objectNamesList = new ArrayList();
    }

    @Override
    public void enterUsualHasClause(FulibScenariosParser.UsualHasClauseContext ctx) {
        this.objectNamesList = new ArrayList();
    }

    @Override
    public void exitUsualWithClause(FulibScenariosParser.UsualWithClauseContext ctx) {
        if (this.objectName == null) {
            this.objectName = StrUtil.downFirstChar(this.objectNamesList.get(0));
        }
    }

    @Override
    public void exitUsualHasClause(FulibScenariosParser.UsualHasClauseContext ctx) {
        if (this.objectName == null) {
            this.objectName = StrUtil.downFirstChar(this.objectNamesList.get(0));
        }
    }

    @Override
    public void enterValueClause(FulibScenariosParser.ValueClauseContext ctx) {
    }

    @Override
    public void enterValueData(FulibScenariosParser.ValueDataContext ctx) {
        String result = "";
        for (ParseTree child : ctx.children) {
            result = result + StrUtil.cap(child.getText());
        }
        result = StrUtil.downFirstChar(result);
        this.objectNamesList.add(result);
    }

    private String getMultiValue(FulibScenariosParser.ValueClauseContext valueContext) {
        String result = "";
        for (ParseTree child : valueContext.children) {
            if (child instanceof TerminalNode) continue;
            result = result + StrUtil.cap(child.getText());
        }
        result = StrUtil.downFirstChar(result);
        return result;
    }

    private String getMultiName(FulibScenariosParser.MultiNameContext objectName) {
        String result = "";
        for (ParseTree child : objectName.children) {
            result = result + StrUtil.cap(child.getText());
        }
        return result;
    }
}

