package org.fulib.scenarios.ast.decl;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.type.Type;


public interface AssociationDecl extends Decl
{
	// =============== Static Methods ===============
	static AssociationDecl of(ClassDecl owner, String name, int cardinality, ClassDecl target, Type type, AssociationDecl other) { return new Impl(owner, name, cardinality, target, type, other); }
	// =============== Properties ===============
	ClassDecl getOwner();
	void setOwner(ClassDecl owner);
	String getName();
	void setName(String name);
	int getCardinality();
	void setCardinality(int cardinality);
	ClassDecl getTarget();
	void setTarget(ClassDecl target);
	Type getType();
	void setType(Type type);
	AssociationDecl getOther();
	void setOther(AssociationDecl other);

	// =============== Methods ===============
	<P, R> R accept(AssociationDecl.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements AssociationDecl
	{
		// =============== Fields ===============
		private ClassDecl owner;
		private String name;
		private int cardinality;
		private ClassDecl target;
		private Type type;
		private AssociationDecl other;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(ClassDecl owner, String name, int cardinality, ClassDecl target, Type type, AssociationDecl other)
		{
			this.owner = owner;
			this.name = name;
			this.cardinality = cardinality;
			this.target = target;
			this.type = type;
			this.other = other;
		}

		// =============== Properties ===============
		@Override public ClassDecl getOwner() { return this.owner; }
		@Override public void setOwner(ClassDecl owner) { this.owner = owner; }
		@Override public String getName() { return this.name; }
		@Override public void setName(String name) { this.name = name; }
		@Override public int getCardinality() { return this.cardinality; }
		@Override public void setCardinality(int cardinality) { this.cardinality = cardinality; }
		@Override public ClassDecl getTarget() { return this.target; }
		@Override public void setTarget(ClassDecl target) { this.target = target; }
		@Override public Type getType() { return this.type; }
		@Override public void setType(Type type) { this.type = type; }
		@Override public AssociationDecl getOther() { return this.other; }
		@Override public void setOther(AssociationDecl other) { this.other = other; }

		// =============== Methods ===============
		@Override public <P, R> R accept(AssociationDecl.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Decl.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(AssociationDecl associationDecl, P par);
	}
}
