package org.fulib.scenarios.ast.decl;

import java.util.List;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.type.Type;


public interface MethodDecl extends Decl
{
	// =============== Static Methods ===============
	static MethodDecl of(ClassDecl owner, String name, List<ParameterDecl> parameters, Type type, SentenceList body) { return new Impl(owner, name, parameters, type, body); }
	// =============== Properties ===============
	ClassDecl getOwner();
	void setOwner(ClassDecl owner);
	String getName();
	void setName(String name);
	List<ParameterDecl> getParameters();
	void setParameters(List<ParameterDecl> parameters);
	Type getType();
	void setType(Type type);
	SentenceList getBody();
	void setBody(SentenceList body);

	// =============== Methods ===============
	<P, R> R accept(MethodDecl.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements MethodDecl
	{
		// =============== Fields ===============
		private ClassDecl owner;
		private String name;
		private List<ParameterDecl> parameters;
		private Type type;
		private SentenceList body;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(ClassDecl owner, String name, List<ParameterDecl> parameters, Type type, SentenceList body)
		{
			this.owner = owner;
			this.name = name;
			this.parameters = parameters;
			this.type = type;
			this.body = body;
		}

		// =============== Properties ===============
		@Override public ClassDecl getOwner() { return this.owner; }
		@Override public void setOwner(ClassDecl owner) { this.owner = owner; }
		@Override public String getName() { return this.name; }
		@Override public void setName(String name) { this.name = name; }
		@Override public List<ParameterDecl> getParameters() { return this.parameters; }
		@Override public void setParameters(List<ParameterDecl> parameters) { this.parameters = parameters; }
		@Override public Type getType() { return this.type; }
		@Override public void setType(Type type) { this.type = type; }
		@Override public SentenceList getBody() { return this.body; }
		@Override public void setBody(SentenceList body) { this.body = body; }

		// =============== Methods ===============
		@Override public <P, R> R accept(MethodDecl.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Decl.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(MethodDecl methodDecl, P par);
	}
}
