package org.fulib.scenarios.ast.decl;

import org.fulib.scenarios.ast.Node;


public interface UnresolvedName extends Name
{
	// =============== Static Methods ===============
	static UnresolvedName of(String value, String text) { return new Impl(value, text); }
	// =============== Properties ===============
	String getValue();
	void setValue(String value);
	String getText();
	void setText(String text);

	// =============== Methods ===============
	<P, R> R accept(UnresolvedName.Visitor<P, R> visitor, P par);
	// =============== Classes ===============
	class Impl implements UnresolvedName
	{
		// =============== Fields ===============
		private String value;
		private String text;

		// =============== Constructors ===============
		public Impl() {}
		public Impl(String value, String text)
		{
			this.value = value;
			this.text = text;
		}

		// =============== Properties ===============
		@Override public String getValue() { return this.value; }
		@Override public void setValue(String value) { this.value = value; }
		@Override public String getText() { return this.text; }
		@Override public void setText(String text) { this.text = text; }

		// =============== Methods ===============
		@Override public <P, R> R accept(UnresolvedName.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Name.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }
		@Override public <P, R> R accept(Node.Visitor<P, R> visitor, P par) { return visitor.visit(this, par); }

	}
	interface Visitor<P, R>
	{
		// =============== Methods ===============
		R visit(UnresolvedName unresolvedName, P par);
	}
}
